/*
 * Decompiled with CFR 0.152.
 */
package savant.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import savant.controller.FrameController;
import savant.settings.PersistentSettings;
import savant.settings.ResolutionSettings;
import savant.settings.Section;
import savant.settings.SettingsDialog;
import savant.view.swing.Frame;

public class ResolutionSettingsSection
extends Section {
    private JFormattedTextField sequenceThresholdField;
    private JFormattedTextField intervalThresholdField;
    private JFormattedTextField bamThresholdField;
    private JFormattedTextField bamArcModeThresholdField;
    private JFormattedTextField continuousThresholdField;
    private JFormattedTextField variantThresholdField;
    private JFormattedTextField ldMaxLociField;

    public String getTitle() {
        return "Track Resolutions";
    }

    public Icon getIcon() {
        return null;
    }

    public void lazyInitialize() {
        GridBagConstraints gbc = this.getFullRowConstraints();
        this.add(SettingsDialog.getHeader(this.getTitle()), gbc);
        this.add(this.getSequencePanel(), gbc);
        this.add(this.getIntervalPanel(), gbc);
        this.add(this.getBAMPanel(), gbc);
        this.add(this.getContinuousPanel(), gbc);
        gbc.weighty = 1.0;
        this.add(this.getVariantPanel(), gbc);
    }

    @Override
    public void applyChanges() {
        if (this.bamArcModeThresholdField != null) {
            ResolutionSettings.setBAMArcModeLowToHighThreshold(Integer.parseInt(this.bamArcModeThresholdField.getText().replaceAll(",", "")));
            ResolutionSettings.setBAMLowToHighThreshold(Integer.parseInt(this.bamThresholdField.getText().replaceAll(",", "")));
            ResolutionSettings.setIntervalLowToHighThreshold(Integer.parseInt(this.intervalThresholdField.getText().replaceAll(",", "")));
            ResolutionSettings.setSequenceLowToHighThreshold(Integer.parseInt(this.sequenceThresholdField.getText().replaceAll(",", "")));
            ResolutionSettings.setContinuousLowToHighThreshold(Integer.parseInt(this.continuousThresholdField.getText().replaceAll(",", "")));
            ResolutionSettings.setVariantLowToHighThreshold(Integer.parseInt(this.variantThresholdField.getText().replaceAll(",", "")));
            ResolutionSettings.setLDMaxLoci(Integer.parseInt(this.ldMaxLociField.getText().replaceAll(",", "")));
            for (Frame f : FrameController.getInstance().getFrames()) {
                f.forceRedraw();
            }
            try {
                PersistentSettings.getInstance().store();
            }
            catch (IOException iox) {
                this.LOG.error((Object)"Unable to save track resolution settings.", (Throwable)iox);
            }
        }
    }

    private JPanel getSequencePanel() {
        this.sequenceThresholdField = this.getFormattedTextField(ResolutionSettings.getSequenceLowToHighThreshold());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Sequence Tracks (FASTA)"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        panel.add((Component)new JLabel("Don't show sequence for ranges larger than"), gbc);
        panel.add((Component)this.sequenceThresholdField, gbc);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        panel.add((Component)new JLabel("bp"), gbc);
        return panel;
    }

    private JPanel getIntervalPanel() {
        this.intervalThresholdField = this.getFormattedTextField(ResolutionSettings.getIntervalLowToHighThreshold());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Interval Tracks (BED, GFF, etc.)"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        panel.add((Component)new JLabel("Don't show intervals for ranges larger than"), gbc);
        panel.add((Component)this.intervalThresholdField, gbc);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        panel.add((Component)new JLabel("bp"), gbc);
        return panel;
    }

    private JPanel getBAMPanel() {
        this.bamThresholdField = this.getFormattedTextField(ResolutionSettings.getBAMLowToHighThreshold());
        this.bamArcModeThresholdField = this.getFormattedTextField(ResolutionSettings.getBAMArcModeLowToHighThreshold());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Read alignment tracks (BAM)"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.anchor = 13;
        panel.add((Component)new JLabel("Show coverage for ranges larger than"), gbc);
        panel.add((Component)this.bamThresholdField, gbc);
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        panel.add((Component)new JLabel("bp"), gbc);
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        panel.add((Component)new JLabel("Don't show mate arcs for ranges larger than"), gbc);
        panel.add((Component)this.bamArcModeThresholdField, gbc);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        panel.add((Component)new JLabel("bp"), gbc);
        return panel;
    }

    private JPanel getContinuousPanel() {
        this.continuousThresholdField = this.getFormattedTextField(ResolutionSettings.getContinuousLowToHighThreshold());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Unformatted Continuous Tracks (WIG, BigWig, etc. from external datasources)"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.anchor = 17;
        panel.add((Component)new JLabel("Don't show levels for ranges larger than"), gbc);
        panel.add((Component)this.continuousThresholdField, gbc);
        gbc.weightx = 1.0;
        panel.add((Component)new JLabel("bp"), gbc);
        return panel;
    }

    private JPanel getVariantPanel() {
        this.variantThresholdField = this.getFormattedTextField(ResolutionSettings.getVariantLowToHighThreshold());
        this.ldMaxLociField = this.getFormattedTextField(ResolutionSettings.getLDMaxLoci());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Variant Tracks (VCF)"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.anchor = 17;
        panel.add((Component)new JLabel("Don't show variants for ranges larger than"), gbc);
        panel.add((Component)this.variantThresholdField, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        panel.add((Component)new JLabel("bp"), gbc);
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        panel.add((Component)new JLabel("Don't generate LD plots for more than"), gbc);
        panel.add((Component)this.ldMaxLociField, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        panel.add((Component)new JLabel("loci"), gbc);
        return panel;
    }

    private JFormattedTextField getFormattedTextField(int amount) {
        JFormattedTextField result = new JFormattedTextField(NumberFormat.getNumberInstance());
        result.setValue(new Integer(amount));
        result.setColumns(10);
        result.setPreferredSize(new Dimension(90, 18));
        result.setMinimumSize(new Dimension(90, 18));
        result.setMaximumSize(new Dimension(90, 18));
        result.addKeyListener(this.enablingKeyListener);
        return result;
    }
}

