/*
 * Decompiled with CFR 0.152.
 */
package savant.settings;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.MultiplePageDialog;
import com.jidesoft.dialog.PageList;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.PartialEtchedBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import savant.settings.ColourSettingsSection;
import savant.settings.GeneralSettingsSection;
import savant.settings.InterfaceSection;
import savant.settings.RemoteFilesSettingsSection;
import savant.settings.ResolutionSettingsSection;
import savant.settings.Section;

public class SettingsDialog
extends MultiplePageDialog {
    public SettingsDialog(Window parent, String title, Section ... sections) throws HeadlessException {
        super((Frame)parent, title);
        this.setStyle(2);
        this.setDefaultCloseOperation(2);
        PageList model = new PageList();
        for (Section s : sections) {
            model.append((AbstractDialogPage)s);
        }
        this.setPageList(model);
        this.pack();
        for (int i = 0; i < model.getPageCount(); ++i) {
            ((Section)model.getPage(i)).populate();
        }
        this.getOkButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SettingsDialog.this.getApplyButton().isEnabled()) {
                    SettingsDialog.this.applySectionChanges();
                }
            }
        });
        this.getApplyButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.applySectionChanges();
            }
        });
        this.setLocationRelativeTo(parent);
    }

    public SettingsDialog(Window parent) throws HeadlessException {
        this(parent, "Preferences", new ColourSettingsSection(), new GeneralSettingsSection(), new InterfaceSection(), new RemoteFilesSettingsSection(), new ResolutionSettingsSection());
    }

    private static Border createSeparatorBorder() {
        return new PartialEtchedBorder(1, 1);
    }

    public static JComponent getHeader(String title) {
        JPanel headerPanel = new JPanel(new BorderLayout(4, 4));
        JLabel label = new JLabel(title);
        headerPanel.add((Component)label, "North");
        JPanel panel = new JPanel();
        panel.setBorder(SettingsDialog.createSeparatorBorder());
        headerPanel.add((Component)panel, "Center");
        return headerPanel;
    }

    protected void initComponents() {
        super.initComponents();
        this.getContentPanel().setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        JComponent indexPanel = this.getIndexPanel();
        if (indexPanel != null) {
            indexPanel.setOpaque(true);
            JLabel label = new JLabel("Category");
            indexPanel.add((Component)label, "First");
        }
        this.getButtonPanel().setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        this.getPagesPanel().setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = super.createButtonPanel();
        AbstractAction okAction = new AbstractAction(UIDefaultsLookup.getString((Object)"OptionPane.okButtonText")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.setDialogResult(0);
                SettingsDialog.this.setVisible(false);
                SettingsDialog.this.dispose();
            }
        };
        AbstractAction cancelAction = new AbstractAction(UIDefaultsLookup.getString((Object)"OptionPane.cancelButtonText")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.setDialogResult(-1);
                SettingsDialog.this.setVisible(false);
                SettingsDialog.this.dispose();
            }
        };
        ((JButton)buttonPanel.getButtonByName("OK")).setAction(okAction);
        ((JButton)buttonPanel.getButtonByName("CANCEL")).setAction(cancelAction);
        this.setDefaultCancelAction(cancelAction);
        this.setDefaultAction(okAction);
        return buttonPanel;
    }

    public JComponent createIndexPanel() {
        if (this.getPageList().getPageCount() > 1) {
            return super.createIndexPanel();
        }
        return null;
    }

    public Dimension getPreferredSize() {
        return new Dimension(750, 500);
    }

    private void applySectionChanges() {
        for (int i = 0; i < this.getPageList().getPageCount(); ++i) {
            ((Section)this.getPageList().getPage(i)).applyChanges();
        }
    }
}

