/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import savant.api.adapter.BookmarkAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.util.RangeUtils;
import savant.controller.LocationController;
import savant.util.Range;

public class Bookmark
implements BookmarkAdapter {
    private String reference;
    private int from;
    private int to;
    private String annotation;

    public Bookmark(String reference, Range r) {
        this(reference, r, "", false);
    }

    public Bookmark(String reference, Range r, boolean addMargin) {
        this(reference, r, "", addMargin);
    }

    public Bookmark(String reference, Range r, String ann) {
        this(reference, r, ann, false);
    }

    public Bookmark(String reference, Range r, String ann, boolean addMargin) {
        this.setReference(reference);
        this.setRange(addMargin ? RangeUtils.addMargin(r) : r);
        this.setAnnotation(ann);
    }

    public Bookmark(String text) throws ParseException {
        this(text, LocationController.getInstance().getReferenceName(), LocationController.getInstance().getRange());
    }

    public Bookmark(String text, String baseRef, Range baseRange) throws ParseException {
        int colonPos;
        this.from = -1;
        this.to = -1;
        if (baseRange != null) {
            this.from = baseRange.getFrom();
            this.to = baseRange.getTo();
        }
        if ((colonPos = (text = text.replace(" ", "")).lastIndexOf(58)) >= 0) {
            this.reference = text.substring(0, colonPos).intern();
            text = text.substring(colonPos + 1);
        } else {
            this.reference = baseRef;
        }
        if (text.length() > 0) {
            NumberFormat numberParser = NumberFormat.getIntegerInstance(Locale.getDefault());
            int minusPos = text.indexOf(45);
            if (minusPos == 0) {
                int delta = numberParser.parse(text.substring(1)).intValue();
                this.from -= delta;
                this.to -= delta;
            } else if (minusPos > 0) {
                int second;
                int first = numberParser.parse(text.substring(0, minusPos)).intValue();
                if (first <= (second = numberParser.parse(text.substring(minusPos + 1)).intValue())) {
                    this.from = first;
                    this.to = second;
                } else {
                    this.from = second;
                    this.to = first;
                }
            } else {
                int plusPos = text.indexOf(43);
                if (plusPos == 0) {
                    int delta = numberParser.parse(text.substring(1)).intValue();
                    this.from += delta;
                    this.to += delta;
                } else if (plusPos > 0) {
                    this.from = numberParser.parse(text.substring(0, plusPos)).intValue();
                    this.to = this.from + numberParser.parse(text.substring(plusPos + 1)).intValue() - 1;
                } else if (LocationController.getInstance().getReferenceNames().contains(text)) {
                    this.reference = text;
                    this.from = 1;
                    this.to = 1000;
                } else {
                    int newFrom = numberParser.parse(text).intValue();
                    this.to += newFrom - this.from;
                    this.from = newFrom;
                }
            }
        }
    }

    public Bookmark(String text, String ann) throws ParseException {
        this(text);
        this.annotation = ann;
        this.setRange(RangeUtils.addMargin(this.getRange()));
    }

    public String toString() {
        return this.annotation;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public final RangeAdapter getRange() {
        return new Range(this.from, this.to);
    }

    @Override
    public String getAnnotation() {
        return this.annotation;
    }

    @Override
    public final void setReference(String r) {
        this.reference = r;
    }

    @Override
    public final void setRange(RangeAdapter r) {
        this.from = r.getFrom();
        this.to = r.getTo();
    }

    @Override
    public final void setAnnotation(String ann) {
        this.annotation = ann;
    }

    public final int getFrom() {
        return this.from;
    }

    public final int getTo() {
        return this.to;
    }

    public final String getLocationText() {
        return String.format("%s:%d-%d", this.reference, this.from, this.to);
    }
}

