/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.awt.Color;
import java.util.EnumMap;
import savant.api.data.VariantType;
import savant.settings.ColourSettings;
import savant.util.ColourKey;

public class ColourScheme {
    private EnumMap<ColourKey, Color> colours = new EnumMap(ColourKey.class);

    public ColourScheme(ColourKey ... keys) {
        for (ColourKey k : keys) {
            this.colours.put(k, null);
        }
    }

    public Color getColor(ColourKey key) {
        Color result = this.colours.get((Object)key);
        if (result == null) {
            result = ColourSettings.getColor(key);
        }
        return result;
    }

    public void setColor(ColourKey key, Color value) {
        this.colours.put(key, value);
    }

    public Color getBaseColor(char baseLetter) {
        switch (baseLetter) {
            case 'A': {
                return this.getColor(ColourKey.A);
            }
            case 'C': {
                return this.getColor(ColourKey.C);
            }
            case 'G': {
                return this.getColor(ColourKey.G);
            }
            case 'T': {
                return this.getColor(ColourKey.T);
            }
            case 'N': {
                return this.getColor(ColourKey.N);
            }
        }
        return null;
    }

    public Color getVariantColor(VariantType var) {
        switch (var) {
            case SNP_A: {
                return this.getBaseColor('A');
            }
            case SNP_C: {
                return this.getBaseColor('C');
            }
            case SNP_G: {
                return this.getBaseColor('G');
            }
            case SNP_T: {
                return this.getBaseColor('T');
            }
            case INSERTION: {
                return this.getColor(ColourKey.INSERTED_BASE);
            }
            case DELETION: {
                return this.getColor(ColourKey.DELETED_BASE);
            }
            case OTHER: {
                return this.getColor(ColourKey.N);
            }
        }
        return null;
    }

    public EnumMap<ColourKey, Color> getMap() {
        return this.colours;
    }
}

