/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import org.broad.tabix.TabixWriter;
import savant.api.data.DataFormat;

public class ColumnMapping {
    public static final String INTERVAL_GENERIC_HEADER = "chrom\tstart\tend\tname";
    public static final String BED_HEADER = "chrom\tstart\tend\tname\tscore\tstrand\tthickStart\tthickEnd\titemRgb\tblockCount\tblockSizes\tblockStarts";
    public static final String KNOWNGENE_HEADER = "name\tchrom\tstrand\ttxStart\ttxEnd\tcdsStart\tcdsEnd\texonCount\texonStarts\texonEnds\tproteinID\talignID";
    public static final String REFGENE_HEADER = "bin\tname\tchrom\tstrand\ttxStart\ttxEnd\tcdsStart\tcdsEnd\texonCount\texonStarts\texonEnds\tid\tname2\tcdsStartStat\tcdsEndStat\texonFrames";
    public static final String GFF_HEADER = "seqname\tsource\tfeature\tstart\tend\tscore\tstrand\tframe\tgroup";
    public static final String GTF_HEADER = "seqname\tsource\tfeature\tstart\tend\tscore\tstrand\tframe\tattributes";
    public static final String PSL_HEADER = "matches\tmisMatches\trepMatches\tnCount\tqNumInsert\tqBaseInsert\ttNumInsert\ttBaseInsert\tstrand\tqName\tqSize\tqStart\tqEnd\ttName\ttSize\ttStart\ttEnd\tblockCount\tblockSizes\tqStarts\ttStarts";
    public static final String VCF_HEADER = "CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT";
    public static final ColumnMapping BED = ColumnMapping.inferMapping("chrom\tstart\tend\tname\tscore\tstrand\tthickStart\tthickEnd\titemRgb\tblockCount\tblockSizes\tblockStarts", false);
    public static final ColumnMapping KNOWNGENE = ColumnMapping.inferMapping("name\tchrom\tstrand\ttxStart\ttxEnd\tcdsStart\tcdsEnd\texonCount\texonStarts\texonEnds\tproteinID\talignID", false);
    public static final ColumnMapping REFSEQ = ColumnMapping.inferMapping("bin\tname\tchrom\tstrand\ttxStart\ttxEnd\tcdsStart\tcdsEnd\texonCount\texonStarts\texonEnds\tid\tname2\tcdsStartStat\tcdsEndStat\texonFrames", false);
    public static final ColumnMapping GFF = ColumnMapping.inferMapping("seqname\tsource\tfeature\tstart\tend\tscore\tstrand\tframe\tgroup", true);
    public static final ColumnMapping GTF = ColumnMapping.inferMapping("seqname\tsource\tfeature\tstart\tend\tscore\tstrand\tframe\tattributes", true);
    public static final ColumnMapping PSL = ColumnMapping.inferMapping("matches\tmisMatches\trepMatches\tnCount\tqNumInsert\tqBaseInsert\ttNumInsert\ttBaseInsert\tstrand\tqName\tqSize\tqStart\tqEnd\ttName\ttSize\ttStart\ttEnd\tblockCount\tblockSizes\tqStarts\ttStarts", false);
    public static final ColumnMapping VCF = new ColumnMapping(DataFormat.VARIANT, 0, 1, -1, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, true);
    public final DataFormat format;
    public final int chrom;
    public final int start;
    public final int end;
    public final int name;
    public final int score;
    public final int strand;
    public final int thickStart;
    public final int thickEnd;
    public final int itemRGB;
    public final int blockStartsRelative;
    public final int blockStartsAbsolute;
    public final int blockEnds;
    public final int blockSizes;
    public final int name2;
    public final boolean oneBased;

    private ColumnMapping(DataFormat format, int chrom, int start, int end, int name, int score, int strand, int thickStart, int thickEnd, int itemRGB, int blockStartsRelative, int blockStartsAbsolute, int blockEnds, int blockSizes, int name2, boolean oneBased) {
        this.format = format;
        this.chrom = chrom;
        this.start = start;
        this.end = end;
        this.name = name;
        this.score = score;
        this.strand = strand;
        this.thickStart = thickStart;
        this.thickEnd = thickEnd;
        this.itemRGB = itemRGB;
        this.blockStartsAbsolute = blockStartsAbsolute;
        this.blockStartsRelative = blockStartsRelative;
        this.blockEnds = blockEnds;
        this.blockSizes = blockSizes;
        this.name2 = name2;
        this.oneBased = oneBased;
    }

    public TabixWriter.Conf getTabixConf(int flags) {
        return new TabixWriter.Conf(flags, this.chrom + 1, this.start + 1, this.end + 1, '#', 0);
    }

    public static ColumnMapping createIntervalMapping(int chrom, int start, int end, int name, boolean oneBased) {
        return new ColumnMapping(DataFormat.GENERIC_INTERVAL, chrom, start, end, name, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, oneBased);
    }

    public static ColumnMapping createRichIntervalMapping(int chrom, int start, int end, int name, int score, int strand, int thickStart, int thickEnd, int itemRGB, int blockStartsRelative, int blockStartsAbsolute, int blockEnds, int blockSizes, int name2, boolean oneBased) {
        return new ColumnMapping(DataFormat.RICH_INTERVAL, chrom, start, end, name, score, strand, thickStart, thickEnd, itemRGB, blockStartsRelative, blockStartsAbsolute, blockEnds, blockSizes, name2, oneBased);
    }

    public static ColumnMapping inferMapping(String header, boolean oneBased) {
        if (header.charAt(0) == '#') {
            header = header.substring(1);
        }
        String[] columnNames = header.split("\\t");
        return ColumnMapping.inferMapping(columnNames, oneBased);
    }

    public static ColumnMapping inferMapping(String[] columnNames, boolean oneBased) {
        int chrom = -1;
        int start = -1;
        int end = -1;
        int name = -1;
        int score = -1;
        int strand = -1;
        int thickStart = -1;
        int thickEnd = -1;
        int itemRGB = -1;
        int blockStartsRelative = -1;
        int blockStartsAbsolute = -1;
        int blockEnds = -1;
        int blockSizes = -1;
        int name2 = -1;
        boolean bed = false;
        for (int i = 0; i < columnNames.length; ++i) {
            String colName = columnNames[i].toLowerCase();
            if (colName.equals("bin")) {
                columnNames[i] = null;
                continue;
            }
            if (colName.equals("chrom") || colName.equals("seqname") || colName.equals("genoname")) {
                chrom = i;
                columnNames[i] = "Reference";
                continue;
            }
            if (colName.equals("start") || colName.equals("txstart") || colName.equals("chromstart") || colName.equals("pos") || colName.equals("genostart")) {
                start = i;
                columnNames[i] = "Start";
                continue;
            }
            if (colName.equals("end") || colName.equals("txend") || colName.equals("chromend") || colName.equals("genoend")) {
                end = i;
                columnNames[i] = "End";
                continue;
            }
            if (colName.equals("name") || colName.equals("qname") || colName.equals("repname")) {
                name = i;
                columnNames[i] = "Name";
                continue;
            }
            if (colName.equals("score")) {
                score = i;
                columnNames[i] = "Score";
                bed = true;
                continue;
            }
            if (colName.equals("strand")) {
                strand = i;
                columnNames[i] = "Strand";
                bed = true;
                continue;
            }
            if (colName.equals("thickstart") || colName.equals("cdsstart")) {
                thickStart = i;
                columnNames[i] = "Thick start";
                bed = true;
                continue;
            }
            if (colName.equals("thickend") || colName.equals("cdsend")) {
                thickEnd = i;
                columnNames[i] = "Thick end";
                bed = true;
                continue;
            }
            if (colName.equals("itemrgb") || colName.equals("reserved")) {
                itemRGB = i;
                columnNames[i] = null;
                bed = true;
                continue;
            }
            if (colName.equals("blockcount") || colName.equals("exoncount")) {
                columnNames[i] = "Block count";
                bed = true;
                continue;
            }
            if (colName.equals("blockstarts")) {
                blockStartsRelative = i;
                columnNames[i] = null;
                bed = true;
                continue;
            }
            if (colName.equals("exonstarts") || colName.equals("tstarts") || colName.equals("chromstarts")) {
                blockStartsAbsolute = i;
                columnNames[i] = null;
                bed = true;
                continue;
            }
            if (colName.equals("blocksizes") || colName.equals("exonsizes")) {
                blockSizes = i;
                columnNames[i] = null;
                bed = true;
                continue;
            }
            if (colName.equals("exonends")) {
                blockEnds = i;
                columnNames[i] = null;
                bed = true;
                continue;
            }
            if (!colName.equals("name2") && !colName.equals("proteinid")) continue;
            name2 = i;
            columnNames[i] = "Alternate name";
            bed = true;
        }
        if (bed) {
            return ColumnMapping.createRichIntervalMapping(chrom, start, end, name, score, strand, thickStart, thickEnd, itemRGB, blockStartsRelative, blockStartsAbsolute, blockEnds, blockSizes, name2, oneBased);
        }
        return ColumnMapping.createIntervalMapping(chrom, start, end, name, oneBased);
    }

    public boolean isOneBased() {
        return this.oneBased;
    }
}

