/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.util.Listener;

public abstract class Controller<E> {
    private static final Log LOG = LogFactory.getLog(Controller.class);
    protected List<Listener<E>> listeners = new ArrayList<Listener<E>>();
    private Stack<List<Listener<E>>> listenersToAdd = new Stack();
    private Stack<List<Listener<E>>> listenersToRemove = new Stack();

    public synchronized void fireEvent(E event) {
        this.listenersToAdd.push(new ArrayList());
        this.listenersToRemove.push(new ArrayList());
        for (Listener<E> l : this.listeners) {
            try {
                l.handleEvent(event);
            }
            catch (Throwable x) {
                LOG.warn((Object)(l + " threw exception while handling event."), x);
            }
        }
        for (Listener<E> l : this.listenersToAdd.pop()) {
            this.listeners.add(l);
        }
        for (Listener<E> l : this.listenersToRemove.pop()) {
            this.listeners.remove(l);
        }
    }

    public void addListener(Listener<E> l) {
        if (this.listenersToAdd.isEmpty()) {
            this.listeners.add(l);
        } else {
            this.listenersToAdd.peek().add(l);
        }
    }

    public void removeListener(Listener<E> l) {
        if (this.listenersToRemove.isEmpty()) {
            this.listeners.remove(l);
        } else {
            this.listenersToRemove.peek().add(l);
        }
    }
}

