/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sf.samtools.SAMRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.util.Range;

public class MiscUtils {
    public static final boolean MAC;
    public static final boolean WINDOWS;
    public static final boolean LINUX;
    public static final String UNSAVED_MARK = " *";
    public static final int MENU_MASK;
    private static final Log LOG;

    public static String numToString(double num) {
        return MiscUtils.numToString(num, 0);
    }

    public static String numToString(double num, int significantdigits) {
        String formatString = "###,###";
        if (significantdigits > 0) {
            formatString = formatString + ".";
            for (int i = 0; i < significantdigits; ++i) {
                formatString = formatString + "#";
            }
        }
        DecimalFormat df = new DecimalFormat(formatString);
        return df.format(num);
    }

    public static int stringToInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            LOG.info((Object)MiscUtils.getMessage(e));
            return -1;
        }
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        return DateFormat.getTimeInstance().format(cal.getTime());
    }

    public static String removeChar(String s, char c) {
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r = r + s.charAt(i);
        }
        return r;
    }

    public static String getFilenameFromPath(String path) {
        int lastSlashIndex = path.lastIndexOf(System.getProperty("file.separator"));
        if (lastSlashIndex == -1) {
            lastSlashIndex = path.lastIndexOf("/");
        }
        return path.substring(lastSlashIndex + 1, path.length());
    }

    public static String getExtension(String path) {
        int dotIndex = path.lastIndexOf(".");
        if (dotIndex == -1 || dotIndex == path.length() - 1) {
            return "";
        }
        return path.substring(dotIndex + 1);
    }

    public static String getTemporaryDirectory() {
        if (MAC || LINUX) {
            String tmpDir = System.getenv("TMPDIR");
            if (tmpDir != null) {
                return tmpDir;
            }
            return "/tmp/savant";
        }
        String tmpDir = System.getenv("TEMP");
        if (tmpDir != null) {
            return tmpDir;
        }
        tmpDir = System.getenv("TMP");
        if (tmpDir != null) {
            return tmpDir;
        }
        return System.getProperty("user.dir");
    }

    public static int transformPixelToPosition(int pixel, int widthOfComponent, Range positionalRange) {
        double positionsperpixel = (double)positionalRange.getLength() / (double)widthOfComponent;
        return positionalRange.getFrom() + (int)Math.floor(positionsperpixel * (double)pixel);
    }

    public static int transformPositionToPixel(int position, int widthOfComponent, Range positionalRange) {
        double pixelsperposition = (double)widthOfComponent / (double)positionalRange.getLength();
        return (int)Math.round((double)(position - positionalRange.getFrom()) * pixelsperposition);
    }

    public static List<String> set2List(Set<String> set) {
        ArrayList<String> l = new ArrayList<String>();
        for (String s : set) {
            l.add(s);
        }
        Collections.sort(l);
        return l;
    }

    public static String posToShortString(int genomepos) {
        return MiscUtils.posToShortString(genomepos, 0);
    }

    public static String posToShortStringWithSeparation(int pos, int separation) {
        if (separation > 10) {
            int backdigits = (int)Math.floor(Math.log10(separation));
            int significantDigits = 0;
            if (pos > 1000000000) {
                significantDigits = 9 - backdigits;
            } else if (pos > 1000000) {
                significantDigits = 6 - backdigits;
            } else if (pos > 1000) {
                significantDigits = 3 - backdigits;
            }
            return MiscUtils.posToShortString(pos, significantDigits);
        }
        return MiscUtils.numToString(pos);
    }

    public static String posToShortString(int pos, int significantDigits) {
        String result = pos > 1000000000 ? MiscUtils.numToString((double)pos / 1.0E9, significantDigits) + " G" : (pos > 1000000 ? MiscUtils.numToString((double)pos / 1000000.0, significantDigits) + " M" : (pos > 1000 ? MiscUtils.numToString((double)pos / 1000.0, significantDigits) + " k" : MiscUtils.numToString(pos, significantDigits)));
        return result;
    }

    public static int[] getTickPositions(double min, double max) {
        int log = (int)Math.floor(Math.log10(max - min) - 0.35);
        int step = log > 0 ? (int)Math.pow(10.0, log) : 1;
        int[] result = new int[(int)(max - min) / step + 1];
        int p0 = (((int)min - 1) / step + 1) * step;
        for (int i = 0; i < result.length; ++i) {
            result[i] = p0;
            p0 += step;
        }
        return result;
    }

    public static int[] getTickPositions(Range r) {
        return MiscUtils.getTickPositions(r.getFrom(), r.getTo() + 1);
    }

    public static String getMessage(Throwable t) {
        if (t instanceof NullPointerException) {
            return "Null pointer exception";
        }
        if (t instanceof FileNotFoundException) {
            return String.format("File %s not found", t.getMessage());
        }
        if (t instanceof ArrayIndexOutOfBoundsException) {
            return "Array index out of bounds: " + t.getMessage();
        }
        if (t instanceof OutOfMemoryError) {
            return "Out of memory: " + t.getMessage();
        }
        if (t instanceof NumberFormatException) {
            String msg = t.getMessage();
            int quotePos = msg.indexOf(34);
            if (quotePos > 0) {
                return String.format("Unable to interpret %s as a number", msg.substring(quotePos));
            }
            return msg;
        }
        if (t.getMessage() != null) {
            return t.getMessage();
        }
        return t.toString();
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        t.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static String homogenizeSequence(String s) {
        String result = s;
        if (result.contains("chr")) {
            result = result.replaceAll("chr", "");
        }
        if (result.contains("Chr")) {
            result = result.replaceAll("Chr", "");
        }
        if (result.contains("contig")) {
            result = result.replaceAll("contig", "");
        }
        if (result.contains("Contig")) {
            result = result.replaceAll("Contig", "");
        }
        return result;
    }

    public static void setFrameVisibility(String frameKey, boolean isVisible, DockingManager m) {
        DockableFrame f = m.getFrame(frameKey);
        if (isVisible) {
            m.showFrame(frameKey);
        } else {
            m.hideFrame(frameKey);
        }
    }

    public static double roundToSignificantDigits(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        if (n == 0) {
            return Math.round(num);
        }
        String s = num + "";
        int index = s.indexOf(".");
        while (n >= s.length() - index) {
            s = s + "0";
        }
        return Double.parseDouble(s.substring(0, index + n + 1));
    }

    public static String getSophisticatedByteString(long bytes) {
        if (bytes < 1000L) {
            return bytes + " KB";
        }
        if (bytes < 1000000000L) {
            return MiscUtils.roundToSignificantDigits((double)bytes / 1000000.0, 1) + " MB";
        }
        return MiscUtils.roundToSignificantDigits((double)bytes / 1.0E9, 2) + " GB";
    }

    public static void setUnsavedTitle(JFrame f, String title, boolean unsaved) {
        f.getRootPane().putClientProperty("Window.documentModified", unsaved);
        if (!MAC && unsaved) {
            f.setTitle(title + UNSAVED_MARK);
        } else {
            f.setTitle(title);
        }
    }

    public static void registerCancelButton(final JButton cancelButton) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JDialog dialog = (JDialog)SwingUtilities.getWindowAncestor(cancelButton);
        dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                cancelButton.doClick();
            }
        }, stroke, 2);
    }

    public static void invokeLaterIfNecessary(Runnable r) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public static String reverseString(String str) {
        int strlen = str.length();
        char[] result = new char[strlen];
        for (int i = 1; i <= strlen; ++i) {
            result[strlen - i] = str.charAt(i - 1);
        }
        return new String(result);
    }

    public static boolean isMate(SAMRecord rec1, SAMRecord rec2, boolean extraCheck) {
        String[][] suffices;
        if (rec1 == rec2) {
            return false;
        }
        String name1 = rec1.getReadName();
        String name2 = rec2.getReadName();
        int len1 = name1.length();
        int len2 = name2.length();
        if (extraCheck ? name1.equals(name2) && rec1.getMateAlignmentStart() == rec2.getAlignmentStart() && rec1.getAlignmentStart() == rec2.getMateAlignmentStart() : name1.equals(name2)) {
            return true;
        }
        for (String[] pair : suffices = new String[][]{{"\\1", "\\2"}, {"_F", "_R"}, {"_F3", "_R3"}}) {
            int len = pair[0].length();
            if (!name1.substring(0, len1 - len).equals(name2.substring(0, len2 - len)) || (!name1.substring(len1 - len).equals(pair[0]) || !name2.substring(len2 - len).equals(pair[1])) && (!name1.substring(len1 - len).equals(pair[1]) || !name2.substring(len2 - len).equals(pair[0]))) continue;
            return true;
        }
        return false;
    }

    public static Color blend(Color col1, Color col2, float weight1) {
        float weight2 = (1.0f - weight1) / 255.0f;
        return new Color((float)col1.getRed() * (weight1 /= 255.0f) + (float)col2.getRed() * weight2, (float)col1.getGreen() * weight1 + (float)col2.getGreen() * weight2, (float)col1.getBlue() * weight1 + (float)col2.getBlue() * weight2);
    }

    public static Path2D.Double createPolygon(double ... coords) {
        if (coords.length < 4 || (coords.length & 1) != 0) {
            throw new IllegalArgumentException("Invalid coordinates for createPolygon");
        }
        Path2D.Double result = new Path2D.Double(1, coords.length / 2);
        result.moveTo(coords[0], coords[1]);
        for (int i = 2; i < coords.length; i += 2) {
            result.lineTo(coords[i], coords[i + 1]);
        }
        result.closePath();
        return result;
    }

    public static void drawMessage(Graphics2D g2, String message, Rectangle2D box) {
        FontMetrics metrics = g2.getFontMetrics();
        Rectangle2D stringBounds = g2.getFont().getStringBounds(message, g2.getFontRenderContext());
        float x = (float)(box.getX() + (box.getWidth() - stringBounds.getWidth()) / 2.0);
        float y = (float)(box.getY() + (box.getHeight() + (double)metrics.getAscent() - (double)metrics.getDescent()) / 2.0);
        g2.drawString(message, x, y);
    }

    static {
        LOG = LogFactory.getLog(MiscUtils.class);
        String os = System.getProperty("os.name").toLowerCase();
        MAC = os.startsWith("mac");
        WINDOWS = os.startsWith("windows");
        LINUX = os.contains("linux");
        MENU_MASK = MAC ? 4 : 2;
    }
}

