/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.sf.samtools.util.SeekableBufferedStream;
import net.sf.samtools.util.SeekableFileStream;
import net.sf.samtools.util.SeekableHTTPStream;
import net.sf.samtools.util.SeekableStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import savant.api.util.Listener;
import savant.exception.UnknownSchemeException;
import savant.settings.BrowserSettings;
import savant.util.CachedSeekableStream;
import savant.util.DownloadEvent;
import savant.util.DownloadMonitor;
import savant.util.MiscUtils;
import savant.util.SeekableFTPStream;

public class NetworkUtils {
    private static final Log LOG = LogFactory.getLog(NetworkUtils.class);
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READ_TIMEOUT = 30000;
    private static final int BUF_SIZE = 8192;

    public static boolean exists(URI uri) {
        try {
            if (uri.getScheme().equals("file")) {
                return new File(uri).exists();
            }
            return NetworkUtils.getHash(uri.toURL()) != null;
        }
        catch (Exception x) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHash(URL url) throws IOException {
        String proto = url.getProtocol().toLowerCase();
        if (proto.equals("http") || proto.equals("https")) {
            URLConnection conn = null;
            try {
                conn = url.openConnection();
                String string = conn.getHeaderField("ETag");
                return string;
            }
            finally {
                if (conn != null && conn instanceof HttpURLConnection) {
                    ((HttpURLConnection)conn).disconnect();
                }
            }
        }
        if (proto.equals("ftp")) {
            SeekableFTPStream ftp = new SeekableFTPStream(url, "anonymous", "");
            try {
                FTPFile[] files = ftp.listFiles(url.getFile());
                if (files.length > 0) {
                    String string = String.format("%016x-%016x", files[0].getTimestamp().getTimeInMillis(), files[0].getSize());
                    return string;
                }
                throw new IOException("URL not found: " + url);
            }
            finally {
                ftp.close();
            }
        }
        if (proto.equals("file")) {
            try {
                File f = new File(url.toURI());
                return String.format("%016x-%016x", f.lastModified(), f.length());
            }
            catch (URISyntaxException x) {
                throw new IllegalArgumentException("Invalid argument; cannot parse " + url + " as a file.");
            }
        }
        throw new IllegalArgumentException("Invalid argument; cannot get hash for " + proto + " URLs.");
    }

    public static SeekableStream getSeekableStreamForURI(URI uri, boolean allowCaching) throws IOException {
        Object result;
        String proto = uri.getScheme().toLowerCase();
        if (proto.equals("file")) {
            result = new SeekableBufferedStream((SeekableStream)new SeekableFileStream(new File(uri)));
        } else {
            if (proto.equals("http") || proto.equals("https")) {
                result = new SeekableHTTPStream(uri.toURL());
            } else if (proto.equals("ftp")) {
                result = new SeekableFTPStream(uri.toURL());
            } else {
                throw new UnknownSchemeException(uri);
            }
            result = allowCaching ? new CachedSeekableStream((SeekableStream)result, BrowserSettings.getRemoteBufferSize(), uri) : new SeekableBufferedStream((SeekableStream)result);
        }
        return result;
    }

    public static SeekableStream getSeekableStreamForURI(URI uri) throws IOException {
        return NetworkUtils.getSeekableStreamForURI(uri, BrowserSettings.getCachingEnabled());
    }

    public static boolean isStreamCached(URI uri) {
        String proto;
        return BrowserSettings.getCachingEnabled() && ((proto = uri.getScheme().toLowerCase()).equals("http") || proto.equals("https") || proto.equals("ftp"));
    }

    public static InputStream openStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(30000);
        return conn.getInputStream();
    }

    public static String getExtension(URL url) {
        return MiscUtils.getExtension(url.toString());
    }

    public static String getFileName(URI uri) {
        String path = uri.toString();
        int lastSlashIndex = path.lastIndexOf("/");
        return path.substring(lastSlashIndex + 1, path.length());
    }

    public static String getNeatPathFromURI(URI u) {
        if (u == null) {
            return "";
        }
        if ("file".equals(u.getScheme())) {
            return new File(u).getAbsolutePath();
        }
        return u.toString();
    }

    public static URI getURIFromPath(String fileOrURI) {
        URI uri = null;
        try {
            uri = new URI(fileOrURI);
            if (uri.getScheme() == null) {
                uri = new File(fileOrURI).toURI();
            }
        }
        catch (URISyntaxException usx) {
            uri = new File(fileOrURI).toURI();
        }
        return uri;
    }

    public static URL getKnownGoodURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ignored) {
            throw new IllegalArgumentException();
        }
    }

    public static URL getKnownGoodURL(URL base, String spec) {
        try {
            String baseStr = base.toString();
            if (!baseStr.endsWith("/")) {
                baseStr = baseStr + "/";
            }
            return new URL(baseStr + spec);
        }
        catch (MalformedURLException ignored) {
            throw new IllegalArgumentException();
        }
    }

    public static File downloadFile(URL u, File destDir, String fileName) throws IOException {
        int bytesRead;
        File f = new File(destDir, fileName != null ? fileName : MiscUtils.getFilenameFromPath(u.getPath()));
        InputStream in = NetworkUtils.openStream(u);
        FileOutputStream out = new FileOutputStream(f);
        byte[] buf = new byte[8192];
        while ((bytesRead = in.read(buf)) != -1) {
            ((OutputStream)out).write(buf, 0, bytesRead);
        }
        return f;
    }

    public static String downloadFile(URL u) throws IOException {
        int bytesRead;
        StringBuilder result = new StringBuilder();
        InputStream in = NetworkUtils.openStream(u);
        byte[] buf = new byte[8192];
        while ((bytesRead = in.read(buf)) != -1) {
            char[] r = new String(buf).toCharArray();
            result.append(r, 0, bytesRead);
        }
        return result.toString();
    }

    public static void downloadFile(final URL u, final File destDir, final String fileName, final DownloadMonitor monitor) {
        new Thread("NetworkUtils.downloadFile"){
            double totalBytes;

            @Override
            public void run() {
                try {
                    int bytesRead;
                    HttpURLConnection httpConn = (HttpURLConnection)u.openConnection();
                    this.totalBytes = httpConn.getContentLength();
                    File destFile = new File(destDir, fileName != null ? fileName : MiscUtils.getFilenameFromPath(u.getPath()));
                    FileOutputStream out = new FileOutputStream(destFile);
                    InputStream in = NetworkUtils.openStream(u);
                    NetworkUtils.fireDownloadEvent(monitor, new DownloadEvent(DownloadEvent.Type.STARTED));
                    byte[] buf = new byte[8192];
                    long bytesSoFar = 0L;
                    while ((bytesRead = in.read(buf)) != -1 && !monitor.isCancelled()) {
                        ((OutputStream)out).write(buf, 0, bytesRead);
                        if (!(this.totalBytes > 0.0)) continue;
                        monitor.handleEvent(new DownloadEvent((double)(bytesSoFar += (long)bytesRead) / this.totalBytes));
                    }
                    NetworkUtils.fireDownloadEvent(monitor, new DownloadEvent(destFile));
                }
                catch (IOException x) {
                    NetworkUtils.fireDownloadEvent(monitor, new DownloadEvent(x));
                }
            }
        }.start();
    }

    private static void fireDownloadEvent(final Listener<DownloadEvent> listener, final DownloadEvent e) {
        MiscUtils.invokeLaterIfNecessary(new Runnable(){

            @Override
            public void run() {
                listener.handleEvent(e);
            }
        });
    }

    static {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            LOG.info((Object)"Setting default SSL socket factory...");
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception x) {
            LOG.error((Object)"Unable to set socket factory.", (Throwable)x);
        }
    }
}

