/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.util.Comparator;

public class ReferenceComparator
implements Comparator<String> {
    @Override
    public int compare(String ref1, String ref2) {
        int pos2;
        if (ref1.contains("_")) {
            if (ref2.contains("_")) {
                return ref1.compareTo(ref2);
            }
            return 1;
        }
        if (ref2.contains("_")) {
            return -1;
        }
        if (ref1.equals("chrM") || ref1.equals("MT")) {
            return 1;
        }
        if (ref2.equals("chrM") || ref2.equals("MT")) {
            return -1;
        }
        int pos1 = this.findFirstArabicDigit(ref1);
        if (pos1 == (pos2 = this.findFirstArabicDigit(ref2))) {
            if (pos1 != -1) {
                int prefixComp = ref1.substring(0, pos1).compareTo(ref2.substring(0, pos2));
                if (prefixComp != 0) {
                    return prefixComp;
                }
                return Integer.parseInt(ref1.substring(pos1)) - Integer.parseInt(ref2.substring(pos2));
            }
            pos1 = this.findFirstRomanDigit(ref1);
            if (pos1 != -1 && pos1 == (pos2 = this.findFirstRomanDigit(ref2))) {
                int prefixComp = ref1.substring(0, pos1).compareTo(ref2.substring(0, pos2));
                if (prefixComp != 0) {
                    return prefixComp;
                }
                int result = this.getSortableRoman(ref1.substring(pos1)).compareTo(this.getSortableRoman(ref2.substring(pos2)));
                return result;
            }
            return ref1.compareTo(ref2);
        }
        if (pos1 == -1) {
            return 1;
        }
        if (pos2 == -1) {
            return -1;
        }
        return pos1 - pos2;
    }

    private int findFirstArabicDigit(String s) {
        int n = s.length() - 1;
        if (!Character.isDigit(s.charAt(n))) {
            return -1;
        }
        for (int i = n - 1; i >= 0; --i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return i + 1;
        }
        return 0;
    }

    private String getSortableRoman(String roman) {
        if (roman.equals("IX")) {
            return "VIIII";
        }
        if (roman.equals("XIX")) {
            return "XVIIII";
        }
        return roman;
    }

    private boolean isRoman(char c) {
        return c == 'I' || c == 'V' || c == 'X';
    }

    private int findFirstRomanDigit(String s) {
        int n = s.length() - 1;
        if (!this.isRoman(s.charAt(n))) {
            return -1;
        }
        for (int i = n - 1; i > 0; --i) {
            if (this.isRoman(s.charAt(i))) continue;
            return i + 1;
        }
        return 0;
    }
}

