/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import net.sf.samtools.SAMRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SAMReadUtils {
    private static final Log LOG = LogFactory.getLog(SAMReadUtils.class);

    public static PairMappingType getPairType(SAMRecord r, PairedSequencingProtocol p) {
        boolean rev;
        boolean sfwd;
        boolean ffwd;
        boolean mp;
        if (!r.getReadPairedFlag() || r.getMateUnmappedFlag()) {
            return PairMappingType.NORMAL;
        }
        if (p == PairedSequencingProtocol.UNKNOWN) {
            p = PairedSequencingProtocol.MATEPAIR;
        }
        boolean bl = mp = p == PairedSequencingProtocol.MATEPAIR;
        if (r.getFirstOfPairFlag()) {
            ffwd = !r.getReadNegativeStrandFlag();
            sfwd = !r.getMateNegativeStrandFlag();
            rev = r.getAlignmentStart() > r.getMateAlignmentStart();
        } else {
            ffwd = !r.getMateNegativeStrandFlag();
            sfwd = !r.getReadNegativeStrandFlag();
            boolean bl2 = rev = r.getMateAlignmentStart() > r.getAlignmentStart();
        }
        if (sfwd && !ffwd && rev || ffwd && !sfwd && !rev) {
            if (mp) {
                return PairMappingType.NORMAL;
            }
            return PairMappingType.INVERTED_MATE;
        }
        if (sfwd && ffwd && rev || !ffwd && !sfwd && !rev) {
            if (mp) {
                return PairMappingType.INVERTED_READ;
            }
            return PairMappingType.EVERTED;
        }
        if (!sfwd && !ffwd && rev || ffwd && sfwd && !rev) {
            if (mp) {
                return PairMappingType.INVERTED_MATE;
            }
            return PairMappingType.NORMAL;
        }
        if (!sfwd && ffwd && rev || !ffwd && sfwd && !rev) {
            if (mp) {
                return PairMappingType.EVERTED;
            }
            return PairMappingType.INVERTED_READ;
        }
        LOG.warn((Object)("Encountered unknown pair possibility:\nprot=" + (Object)((Object)p) + "first=" + r.getFirstOfPairFlag() + " neg=" + r.getReadNegativeStrandFlag() + " mneg=" + r.getMateNegativeStrandFlag() + " ffwd=" + ffwd + " sfwd=" + sfwd + " rev=" + rev + ": "));
        return PairMappingType.UNKNOWN;
    }

    public static enum PairMappingType {
        NORMAL,
        INVERTED_MATE,
        INVERTED_READ,
        EVERTED,
        UNKNOWN;

    }

    public static enum PairedSequencingProtocol {
        UNKNOWN,
        UNPAIRED,
        MATEPAIR,
        PAIREDEND;

    }
}

