/*
 * Decompiled with CFR 0.152.
 */
package savant.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.data.Block;
import savant.data.types.ItemRGB;
import savant.file.FieldType;
import savant.file.FileType;
import savant.file.FileTypeHeader;
import savant.file.ROFile;
import savant.format.SavantFileFormatterUtils;
import savant.util.MiscUtils;
import savant.util.Range;
import savant.util.ReferenceComparator;

public class SavantFileUtils {
    private static final Log LOG = LogFactory.getLog(SavantFileUtils.class);

    public static List<FieldType> readFieldsHeader(ROFile src) throws IOException {
        int numFields = src.readInt();
        ArrayList<FieldType> fields = new ArrayList<FieldType>();
        for (int i = 0; i < numFields; ++i) {
            fields.add(((FieldType[])FieldType.class.getEnumConstants())[src.readInt()]);
        }
        return fields;
    }

    public static int getRecordSize(ROFile file) throws IOException {
        long currpos = file.getFilePointer();
        file.seek(MiscUtils.set2List(file.getReferenceMap().keySet()).get(0), 0L);
        List<Object> record = SavantFileUtils.readBinaryRecord(file, file.getFields());
        file.seek(currpos);
        return SavantFileFormatterUtils.getRecordSize(record, file.getFields());
    }

    public static List<Object> readBinaryRecord(ROFile file, List<FieldType> fields) throws IOException {
        ArrayList<Object> record = new ArrayList<Object>(fields.size());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Reading binary record");
            LOG.debug((Object)"Fields");
            for (FieldType ft : fields) {
                LOG.debug((Object)("\t" + (Object)((Object)ft)));
            }
        }
        block13: for (FieldType ft : fields) {
            if (ft == FieldType.IGNORE) continue;
            switch (ft) {
                case INTEGER: {
                    record.add(file.readInt());
                    continue block13;
                }
                case ITEMRGB: {
                    int r = file.readInt();
                    int g = file.readInt();
                    int b = file.readInt();
                    record.add(ItemRGB.valueOf(r, g, b));
                    continue block13;
                }
                case DOUBLE: {
                    record.add(file.readDouble());
                    continue block13;
                }
                case FLOAT: {
                    record.add(Float.valueOf(file.readFloat()));
                    continue block13;
                }
                case BLOCKS: {
                    int numBlocks = file.readInt();
                    ArrayList<Block> blocks = new ArrayList<Block>(numBlocks);
                    for (int i = 0; i < numBlocks; ++i) {
                        int start = file.readInt();
                        int size = file.readInt();
                        blocks.add(Block.valueOf(start, size));
                    }
                    record.add(blocks);
                    continue block13;
                }
                case STRING: {
                    int len = file.readInt();
                    if (len > 10000) {
                        throw new IOException("Tried to read binary string of length " + len + " characters");
                    }
                    String s = "";
                    for (int i = 0; i < len; ++i) {
                        s = s + (char)file.readByte();
                    }
                    record.add(s);
                    continue block13;
                }
                case CHAR: {
                    record.add(Character.valueOf((char)file.readByte()));
                    continue block13;
                }
                case RANGE: {
                    int start = file.readInt();
                    int end = file.readInt();
                    record.add(new Range(start, end));
                    continue block13;
                }
                case LONG: {
                    record.add(file.readLong());
                    continue block13;
                }
                case IGNORE: {
                    continue block13;
                }
            }
            LOG.warn((Object)("Not implemented yet for Field Type: " + (Object)((Object)ft)));
        }
        return record;
    }

    public static FileTypeHeader readFileTypeHeader(ROFile rof) throws IOException {
        ArrayList<FieldType> fields = new ArrayList<FieldType>();
        fields.add(FieldType.INTEGER);
        fields.add(FieldType.INTEGER);
        List<Object> record = SavantFileUtils.readBinaryRecord(rof, fields);
        Integer magicNumber = (Integer)record.get(0);
        FileTypeHeader fth = new FileTypeHeader(FileType.fromMagicNumber(magicNumber), (Integer)record.get(1));
        if (fth.fileType == null && SavantFileUtils.littleEndian(magicNumber)) {
            throw new IOException("File is LITTLE_ENDIAN.");
        }
        return fth;
    }

    public static Map<String, long[]> readReferenceMap(ROFile rof) throws IOException {
        int numRefs = rof.readInt();
        ArrayList<FieldType> fields = new ArrayList<FieldType>();
        fields.add(FieldType.STRING);
        fields.add(FieldType.LONG);
        fields.add(FieldType.LONG);
        ArrayList<ReferenceInfo> unsortedRefs = new ArrayList<ReferenceInfo>(numRefs);
        for (int i = 0; i < numRefs; ++i) {
            List<Object> record = SavantFileUtils.readBinaryRecord(rof, fields);
            long[] vals = new long[]{(Long)record.get(1), (Long)record.get(2)};
            unsortedRefs.add(new ReferenceInfo(((String)record.get(0)).trim(), vals));
        }
        Collections.sort(unsortedRefs, new Comparator<ReferenceInfo>(){
            private ReferenceComparator comparator = new ReferenceComparator();

            @Override
            public int compare(ReferenceInfo t1, ReferenceInfo t2) {
                return this.comparator.compare(t1.ref, t2.ref);
            }
        });
        LinkedHashMap<String, long[]> referenceMap = new LinkedHashMap<String, long[]>();
        for (ReferenceInfo info : unsortedRefs) {
            referenceMap.put(info.ref, info.vals);
        }
        return referenceMap;
    }

    private static boolean littleEndian(Integer magicNumber) {
        boolean result = false;
        Integer highOrderWord = magicNumber >> 16;
        Integer highOrderWordLittleEndian = (highOrderWord & 0xFF) << 8 & highOrderWord >> 8;
        Integer lowOrderWord = magicNumber & 0xFFFF;
        Integer lowOrderWordLittleEndian = (lowOrderWord & 0xFF) << 8 & lowOrderWord >> 8;
        Integer magicNumberLittleEndian = highOrderWordLittleEndian << 16 & lowOrderWordLittleEndian;
        if (FileType.fromMagicNumber(magicNumberLittleEndian) != null) {
            result = true;
        }
        return result;
    }

    private static class ReferenceInfo {
        String ref;
        long[] vals;

        ReferenceInfo(String ref, long[] vals) {
            this.ref = ref;
            this.vals = vals;
        }
    }
}

