/*
 * Decompiled with CFR 0.152.
 */
package savant.util.error.report;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;

public class BugReport {
    public static String reportURL = "http://www.genomesavant.com/p/assets/include/form/both/bugreport-post.php";

    public static boolean reportBug(String tool, String version, String name, String email, String institute, String problem, Throwable t) throws UnsupportedEncodingException {
        try {
            String params = "tool=" + tool + "&name=" + name + "&email=" + email + "&institution=" + institute + "&problem=" + problem + "&exception=" + BugReport.getStackTrace(t) + "&clientinfo=" + BugReport.kvp("program-version", version) + ", " + BugReport.kvp("java-version", BugReport.getJDKVersion()) + ", " + BugReport.kvp("os", BugReport.getOS()) + ", " + BugReport.kvp("time", new Date().toString());
            BugReport.postRequest(new URL(reportURL), params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        t.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    private static String kvp(String k, String v) {
        return k + "=" + v;
    }

    private static String getJDKVersion() {
        return BugReport.getProperty("java.version");
    }

    private static String getOS() {
        return BugReport.getProperty("os.name") + " " + BugReport.getProperty("os.arch") + " " + BugReport.getProperty("os.version");
    }

    private static String getProperty(String propertyName) {
        try {
            String value = System.getProperty(propertyName);
            if (value == null) {
                return "unknown";
            }
            return value;
        }
        catch (SecurityException e) {
            return "unknown";
        }
    }

    private static void postRequest(URL url, String params) throws IOException {
        String inputLine;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
        wr.writeBytes(params);
        wr.flush();
        wr.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((inputLine = in.readLine()) != null) {
            System.out.println(inputLine);
        }
        in.close();
        connection.disconnect();
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        BugReport.reportBug("Savant", "2.0.4", "Marc Fiume 3", "mfiume@cs.toronto.edu", "UofT", "My description of the problem", new Exception("msg"));
        System.out.println("Bug reported");
    }
}

