/*
 * Decompiled with CFR 0.152.
 */
package savant.util.export;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import savant.api.adapter.BAMDataSourceAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.TrackAdapter;
import savant.api.data.Record;
import savant.api.util.Resolution;
import savant.data.types.BAMIntervalRecord;
import savant.util.DownloadEvent;
import savant.util.export.TrackExporter;

public class BAMExporter
extends TrackExporter {
    SAMFileWriter samWriter;

    BAMExporter(TrackAdapter t, File f) {
        super(t, f);
        this.samWriter = new SAMFileWriterFactory().setCreateIndex(true).makeSAMOrBAMWriter(((BAMDataSourceAdapter)((Object)this.track.getDataSource())).getHeader(), true, this.destFile);
    }

    @Override
    void close() {
        if (this.samWriter != null) {
            this.samWriter.close();
        }
    }

    @Override
    void exportRange(String ref, RangeAdapter r) throws IOException, InterruptedException {
        this.fireEvent(new DownloadEvent(-1.0));
        List recs = this.track.getDataSource().getRecords(ref, r, Resolution.HIGH, null);
        this.fireEvent(new DownloadEvent(0.5));
        for (Record rec : recs) {
            this.samWriter.addAlignment(((BAMIntervalRecord)rec).getSAMRecord());
        }
        this.fireEvent(new DownloadEvent(1.0));
    }
}

