/*
 * Decompiled with CFR 0.152.
 */
package savant.util.export;

import java.io.File;
import java.io.IOException;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.TrackAdapter;
import savant.api.util.TrackUtils;
import savant.controller.LocationController;
import savant.util.Controller;
import savant.util.DownloadEvent;
import savant.util.Range;
import savant.util.export.BAMExporter;
import savant.util.export.FastaExporter;

public abstract class TrackExporter
extends Controller<DownloadEvent> {
    protected final TrackAdapter track;
    protected long basesSoFar;
    protected long totalBases;
    protected File destFile;

    protected TrackExporter(TrackAdapter t, File f) {
        this.track = t;
        this.destFile = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String ref, RangeAdapter r) throws IOException, InterruptedException {
        LocationController lc = LocationController.getInstance();
        try {
            if (ref == null) {
                for (String ref2 : lc.getReferenceNames()) {
                    this.totalBases += (long)lc.getReferenceLength(ref2);
                }
                for (String ref2 : lc.getReferenceNames()) {
                    this.exportRange(ref2, new Range(1, lc.getReferenceLength(ref2)));
                }
            } else {
                this.totalBases = LocationController.getInstance().getReferenceLength(ref);
                if (r == null) {
                    r = new Range(1, (int)this.totalBases);
                }
                this.exportRange(ref, r);
            }
        }
        finally {
            this.close();
        }
        this.fireEvent(new DownloadEvent(this.destFile));
    }

    abstract void close() throws IOException;

    abstract void exportRange(String var1, RangeAdapter var2) throws IOException, InterruptedException;

    public static TrackExporter getExporter(String trackURI, File f) throws IOException {
        TrackAdapter t = TrackUtils.getTrack(trackURI);
        switch (t.getDataFormat()) {
            case SEQUENCE: {
                return new FastaExporter(t, f);
            }
            case ALIGNMENT: {
                return new BAMExporter(t, f);
            }
        }
        return null;
    }
}

