/*
 * Decompiled with CFR 0.152.
 */
package savant.util.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import savant.util.swing.DocumentViewer;
import savant.view.icon.SavantIconFactory;

public class PathField
extends JPanel {
    JTextField f = new JTextField();
    JButton b = new JButton("...");
    JFileChooser fc = new JFileChooser();

    public PathField(int JFileChooserDialogType) {
        this(JFileChooserDialogType, false, false);
    }

    public PathField(final int JFileChooserDialogType, boolean showFileButton, boolean directoriesOnly) {
        this.f.setMaximumSize(new Dimension(9999, 22));
        if (JFileChooserDialogType == 1) {
            this.fc.setDialogTitle("Save File");
            this.f.setToolTipText("Path to output file");
            this.b.setToolTipText("Set output file");
        } else {
            this.fc.setDialogTitle("Open File");
            this.f.setToolTipText("Path to input file");
            this.b.setToolTipText("Choose input file");
        }
        if (directoriesOnly) {
            this.fc.setFileSelectionMode(1);
        }
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.f);
        this.add(this.b);
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathField.this.fc.setDialogType(JFileChooserDialogType);
                int result = PathField.this.fc.showDialog(null, null);
                if (result == 1 || result == -1) {
                    return;
                }
                PathField.this.setPath(PathField.this.fc.getSelectedFile().getAbsolutePath());
            }
        });
        if (showFileButton) {
            JButton showButt = new JButton();
            showButt.setToolTipText("Show file");
            showButt.setIcon(SavantIconFactory.getInstance().getIcon(SavantIconFactory.StandardIcon.VIEW));
            showButt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DocumentViewer v = DocumentViewer.getInstance();
                    v.addDocument(PathField.this.getPath());
                }
            });
            this.add(showButt);
        }
    }

    public String getPath() {
        return this.f.getText();
    }

    public void setPath(String s) {
        this.f.setText(s);
    }

    public JFileChooser getFileChooser() {
        return this.fc;
    }
}

