/*
 * Decompiled with CFR 0.152.
 */
package savant.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.data.DataFormat;
import savant.controller.FrameController;
import savant.settings.PersistentSettings;
import savant.util.MiscUtils;
import savant.view.swing.Frame;

public class TrackChooser
extends JDialog {
    private static final Log LOG = LogFactory.getLog(TrackChooser.class);
    private boolean multiple;
    private JList leftList;
    private JList rightList;
    private String[] retVal;
    private JComboBox filterCombo;
    private String[] filteredTracks = null;
    private JCheckBox autoSelectAllCheck;
    private boolean selectBase;
    private JTextField selectBaseField;
    private int baseSelected = -1;

    public TrackChooser(Window parent, boolean multiple, String title) {
        this(parent, multiple, title, false, -1);
    }

    public TrackChooser(Window parent, boolean multiple, String title, boolean selectBase) {
        this(parent, multiple, title, selectBase, -1);
    }

    public TrackChooser(Window parent, boolean multiple, String title, boolean selectBase, int defaultBase) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.multiple = multiple;
        this.selectBase = selectBase;
        this.setTitle(title);
        this.init();
        this.initLists();
        if (selectBase && defaultBase != -1) {
            this.selectBaseField.setText(MiscUtils.numToString(defaultBase));
        }
        if (this.getAutoSelect()) {
            this.selectAll();
        }
        this.setLocationRelativeTo(null);
    }

    public String[] getSelectedTracks() {
        return this.retVal;
    }

    public int getBaseSelected() {
        return this.baseSelected;
    }

    private void filter() {
        DataFormat ff;
        if (this.filteredTracks != null) {
            for (int i = 0; i < this.filteredTracks.length; ++i) {
                ((TrackListModel)this.leftList.getModel()).add(this.filteredTracks[i]);
            }
            this.filteredTracks = null;
        }
        this.leftList.updateUI();
        this.leftList.clearSelection();
        Object selected = this.filterCombo.getSelectedItem();
        DataFormat dataFormat = ff = selected instanceof DataFormat ? (DataFormat)((Object)selected) : null;
        if (ff == null) {
            this.leftList.updateUI();
            this.leftList.clearSelection();
            return;
        }
        String[] leftTracks = ((TrackListModel)this.leftList.getModel()).getAll();
        List<Frame> frames = FrameController.getInstance().getFrames();
        String[] removed = new String[leftTracks.length];
        int[] remove = new int[leftTracks.length];
        int count = 0;
        block1: for (int i = 0; i < leftTracks.length; ++i) {
            String current = leftTracks[i];
            for (int j = 0; j < frames.size(); ++j) {
                if (!frames.get(j).getName().equals(current)) continue;
                if (frames.get(j).getTracks()[0].getDataFormat().equals((Object)ff)) continue block1;
                remove[count] = i;
                removed[count] = current;
                ++count;
                continue block1;
            }
        }
        int[] removeFinal = new int[count];
        String[] removedFinal = new String[count];
        for (int i = 0; i < count; ++i) {
            removeFinal[i] = remove[i];
            removedFinal[i] = removed[i];
        }
        this.filteredTracks = removedFinal;
        ((TrackListModel)this.leftList.getModel()).removeIndices(removeFinal);
        this.leftList.updateUI();
        this.leftList.clearSelection();
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JLabel leftLabel = new JLabel("All Tracks");
        leftLabel.setFont(new Font(null, 1, 12));
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        this.add((Component)leftLabel, c);
        JLabel rightLabel = new JLabel("Selected Tracks");
        rightLabel.setFont(new Font(null, 1, 12));
        c.gridx = 2;
        c.gridwidth = 0;
        this.add((Component)rightLabel, c);
        this.leftList = new JList();
        JScrollPane leftScroll = new JScrollPane();
        leftScroll.setViewportView(this.leftList);
        leftScroll.setMinimumSize(new Dimension(450, 300));
        leftScroll.setPreferredSize(new Dimension(450, 300));
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 4;
        this.add((Component)leftScroll, c);
        this.rightList = new JList();
        JScrollPane rightScroll = new JScrollPane();
        rightScroll.setViewportView(this.rightList);
        rightScroll.setMinimumSize(new Dimension(450, 300));
        rightScroll.setPreferredSize(new Dimension(450, 300));
        c.gridx = 2;
        c.gridwidth = 0;
        this.add((Component)rightScroll, c);
        c.weightx = 0.0;
        c.weighty = 0.5;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.add((Component)this.createMoveRight(), c);
        c.gridy = 2;
        this.add((Component)this.createMoveLeft(), c);
        c.gridy = 3;
        this.add((Component)this.createAllRight(), c);
        c.gridy = 4;
        this.add((Component)this.createAllLeft(), c);
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.createFilterPanel(), c);
        c.gridx = 2;
        this.add((Component)this.createSelectAllCheck(), c);
        JSeparator separator1 = new JSeparator(0);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)separator1, c);
        if (this.selectBase) {
            JPanel selectBasePanel = new JPanel(new BorderLayout());
            c.gridwidth = 2;
            this.add((Component)selectBasePanel, c);
            JLabel selectBaseLabel = new JLabel("(Optional) Select Base: ");
            selectBasePanel.add((Component)selectBaseLabel, "West");
            this.selectBaseField = new JTextField();
            selectBasePanel.add((Component)this.selectBaseField, "Center");
            JLabel selectBaseExample = new JLabel("  ex. 123,456,789");
            selectBasePanel.add((Component)selectBaseExample, "East");
            JSeparator separator2 = new JSeparator(0);
            c.gridwidth = 0;
            this.add((Component)separator2, c);
        }
        JPanel okCancelPanel = new JPanel(new BorderLayout());
        c.anchor = 13;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)okCancelPanel, c);
        okCancelPanel.add((Component)this.createOKButton(), "Center");
        okCancelPanel.add((Component)this.createCancelButton(), "East");
        this.pack();
    }

    private JPanel createFilterPanel() {
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BorderLayout());
        JLabel filterLabel = new JLabel("Filter By: ");
        filterPanel.add((Component)filterLabel, "West");
        this.filterCombo = new JComboBox();
        filterPanel.add((Component)this.filterCombo, "East");
        return filterPanel;
    }

    private JButton createOKButton() {
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackChooser.access$002(TrackChooser.this, ((TrackListModel)TrackChooser.this.rightList.getModel()).getAll());
                if (TrackChooser.this.autoSelectAllCheck.isSelected() != TrackChooser.this.getAutoSelect()) {
                    TrackChooser.this.setAutoSelect(TrackChooser.this.autoSelectAllCheck.isSelected());
                    try {
                        PersistentSettings.getInstance().store();
                    }
                    catch (IOException ex) {
                        LOG.error((Object)"Unable to store preferences.", (Throwable)ex);
                    }
                }
                if (TrackChooser.this.selectBase) {
                    try {
                        TrackChooser.this.baseSelected = Integer.parseInt(TrackChooser.this.selectBaseField.getText().replaceAll(",", ""));
                    }
                    catch (NumberFormatException ex) {
                        TrackChooser.this.baseSelected = -1;
                    }
                }
                TrackChooser.this.dispose();
            }
        });
        return okButton;
    }

    private JButton createCancelButton() {
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackChooser.access$002(TrackChooser.this, null);
                TrackChooser.this.dispose();
            }
        });
        return cancelButton;
    }

    private boolean getAutoSelect() {
        return PersistentSettings.getInstance().getBoolean("TRACK_CHOOSER_AUTO_SELECT", false);
    }

    private void setAutoSelect(boolean value) {
        PersistentSettings.getInstance().setBoolean("TRACK_CHOOSER_AUTO_SELECT", value);
    }

    private JButton createMoveRight() {
        JButton moveRight = new JButton(">");
        moveRight.setToolTipText("Add item(s) to selected");
        moveRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selected = TrackChooser.this.leftList.getSelectedValues();
                if (selected.length > 1 && !TrackChooser.this.multiple) {
                    return;
                }
                if (((TrackListModel)TrackChooser.this.rightList.getModel()).getSize() > 0 && !TrackChooser.this.multiple) {
                    return;
                }
                for (int i = 0; i < selected.length; ++i) {
                    ((TrackListModel)TrackChooser.this.rightList.getModel()).add(selected[i].toString());
                }
                ((TrackListModel)TrackChooser.this.leftList.getModel()).removeIndices(TrackChooser.this.leftList.getSelectedIndices());
                TrackChooser.this.rightList.updateUI();
                TrackChooser.this.leftList.updateUI();
                TrackChooser.this.leftList.clearSelection();
                TrackChooser.this.rightList.clearSelection();
            }
        });
        return moveRight;
    }

    private JButton createMoveLeft() {
        JButton moveLeft = new JButton("<");
        moveLeft.setToolTipText("Remove item(s) from selected");
        moveLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selected = TrackChooser.this.rightList.getSelectedValues();
                if (selected.length > 1 && !TrackChooser.this.multiple) {
                    return;
                }
                for (int i = 0; i < selected.length; ++i) {
                    ((TrackListModel)TrackChooser.this.leftList.getModel()).add(selected[i].toString());
                }
                ((TrackListModel)TrackChooser.this.rightList.getModel()).removeIndices(TrackChooser.this.rightList.getSelectedIndices());
                TrackChooser.this.leftList.updateUI();
                TrackChooser.this.rightList.updateUI();
                TrackChooser.this.leftList.clearSelection();
                TrackChooser.this.rightList.clearSelection();
            }
        });
        return moveLeft;
    }

    private JButton createAllRight() {
        JButton allRight = new JButton(">>");
        allRight.setToolTipText("Add all to selected");
        if (!this.multiple) {
            allRight.setEnabled(false);
        }
        allRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackChooser.this.selectAll();
            }
        });
        return allRight;
    }

    private JButton createAllLeft() {
        JButton allLeft = new JButton("<<");
        allLeft.setToolTipText("Remove all from selected");
        if (!this.multiple) {
            allLeft.setEnabled(false);
        }
        allLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] stringsRight = ((TrackListModel)TrackChooser.this.rightList.getModel()).getAll();
                for (int i = 0; i < stringsRight.length; ++i) {
                    ((TrackListModel)TrackChooser.this.leftList.getModel()).add(stringsRight[i]);
                }
                ((TrackListModel)TrackChooser.this.rightList.getModel()).removeAll();
                TrackChooser.this.leftList.updateUI();
                TrackChooser.this.rightList.updateUI();
                TrackChooser.this.leftList.clearSelection();
                TrackChooser.this.rightList.clearSelection();
            }
        });
        return allLeft;
    }

    private JCheckBox createSelectAllCheck() {
        this.autoSelectAllCheck = new JCheckBox("Always select all");
        this.autoSelectAllCheck.setSelected(this.getAutoSelect());
        return this.autoSelectAllCheck;
    }

    private void init() {
        this.initLayout();
    }

    private void initLists() {
        int i;
        this.leftList.setModel(new TrackListModel());
        this.rightList.setModel(new TrackListModel());
        List<Frame> frames = FrameController.getInstance().getFrames();
        String[] trackNames = new String[frames.size()];
        ArrayList<DataFormat> fileFormats = new ArrayList<DataFormat>();
        for (i = 0; i < frames.size(); ++i) {
            trackNames[i] = frames.get(i).getName();
            DataFormat ff = frames.get(i).getTracks()[0].getDataFormat();
            if (fileFormats.contains((Object)ff)) continue;
            fileFormats.add(ff);
        }
        this.filterCombo.addItem("All");
        for (i = 0; i < fileFormats.size(); ++i) {
            this.filterCombo.addItem(fileFormats.get(i));
        }
        this.filterCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackChooser.this.filter();
            }
        });
        ((TrackListModel)this.leftList.getModel()).init(trackNames);
    }

    private void selectAll() {
        String[] stringsLeft = ((TrackListModel)this.leftList.getModel()).getAll();
        for (int i = 0; i < stringsLeft.length; ++i) {
            ((TrackListModel)this.rightList.getModel()).add(stringsLeft[i]);
        }
        ((TrackListModel)this.leftList.getModel()).removeAll();
        this.leftList.updateUI();
        this.rightList.updateUI();
        this.leftList.clearSelection();
        this.rightList.clearSelection();
    }

    static /* synthetic */ String[] access$002(TrackChooser x0, String[] x1) {
        x0.retVal = x1;
        return x1;
    }

    private class TrackListModel
    extends DefaultListModel {
        String[] strings = new String[0];

        private TrackListModel() {
        }

        @Override
        public int getSize() {
            return this.strings.length;
        }

        @Override
        public Object getElementAt(int i) {
            return this.strings[i];
        }

        public void init(String[] strings1) {
            this.strings = strings1;
        }

        public void add(String s) {
            String[] strings1 = new String[this.strings.length + 1];
            System.arraycopy(this.strings, 0, strings1, 0, this.strings.length);
            strings1[this.strings.length] = s;
            this.strings = strings1;
        }

        public void removeIndex(int i) {
            if (this.strings.length <= i || i < 0) {
                return;
            }
            String[] strings1 = new String[this.strings.length - 1];
            int k = 0;
            for (int j = 0; j < this.strings.length; ++j) {
                if (j == i) continue;
                strings1[k] = this.strings[j];
                ++k;
            }
            this.strings = strings1;
        }

        public void removeIndices(int[] indices) {
            int i;
            String[] strings1 = new String[this.strings.length - indices.length];
            int[] strings2 = new int[this.strings.length];
            for (i = 0; i < this.strings.length; ++i) {
                strings2[i] = 1;
            }
            for (i = 0; i < indices.length; ++i) {
                strings2[indices[i]] = 0;
            }
            int j = 0;
            for (int i2 = 0; i2 < this.strings.length; ++i2) {
                if (strings2[i2] != 1) continue;
                strings1[j] = this.strings[i2];
                ++j;
            }
            this.strings = strings1;
        }

        public String[] getAll() {
            return this.strings;
        }

        public void removeAll() {
            this.strings = new String[0];
        }
    }
}

