/*
 * Decompiled with CFR 0.152.
 */
package savant.view.dialog;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import savant.util.swing.SpringUtilities;
import savant.view.swing.Savant;

public class BasicFormDialog
extends JDialog {
    private JTextField[] fields;
    private static final int INIT_X = 6;
    private static final int INIT_Y = 6;
    private static final int XPAD = 6;
    private static final int YPAD = 6;
    private boolean wasCancelled = false;

    public String getText(int index) {
        return this.fields[index].getText();
    }

    public BasicFormDialog(String[] names, String[] defaultValues, int[] widths) {
        this((Window)Savant.getInstance(), names, defaultValues, widths);
    }

    public BasicFormDialog(Window parent, String[] names, String[] defaultValues, int[] widths) {
        super(parent);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel p = new JPanel(new SpringLayout());
        this.fields = new JTextField[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String defaultValue = defaultValues != null && i < defaultValues.length ? defaultValues[i] : "";
            this.fields[i] = name.toLowerCase().contains("password") ? new JPasswordField(defaultValue) : new JTextField(defaultValue);
            if (widths != null && i < widths.length) {
                this.fields[i].setColumns(widths[i]);
            }
            JLabel l = new JLabel(name);
            p.add(l);
            l.setLabelFor(this.fields[i]);
            p.add(this.fields[i]);
        }
        SpringUtilities.makeCompactGrid(p, names.length, 2, 6, 6, 6, 6);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton OKButton = new JButton("OK");
        OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BasicFormDialog.this.dispose();
                String[] values = new String[BasicFormDialog.this.fields.length];
                for (int i = 0; i < BasicFormDialog.this.fields.length; ++i) {
                    values[i] = BasicFormDialog.this.fields[i].getText();
                }
                BasicFormDialog.this.submit(values);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BasicFormDialog.this.wasCancelled = true;
                BasicFormDialog.this.dispose();
            }
        });
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(OKButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(Box.createHorizontalGlue());
        mainPanel.add(p);
        mainPanel.add(buttonPanel);
        this.setContentPane(mainPanel);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public void submit(String[] values) {
    }
}

