/*
 * Decompiled with CFR 0.152.
 */
package savant.view.dialog;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import savant.api.util.DialogUtils;
import savant.mail.Mail;
import savant.util.MiscUtils;

public class FeatureRequestDialog
extends JDialog {
    private JButton cancelButton;
    private JTextArea descriptionField;
    private JTextField emailField;
    private JTextField institutionField;
    private JTextField nameField;
    private JComboBox requestTypeCombo;
    private JButton sendButton;

    public FeatureRequestDialog() {
        super(DialogUtils.getMainWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.pack();
        this.getRootPane().setDefaultButton(this.sendButton);
        MiscUtils.registerCancelButton(this.cancelButton);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.descriptionField = new JTextArea();
        JLabel jLabel3 = new JLabel();
        this.cancelButton = new JButton();
        this.sendButton = new JButton();
        this.nameField = new JTextField();
        this.emailField = new JTextField();
        JLabel jLabel4 = new JLabel();
        this.institutionField = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.requestTypeCombo = new JComboBox();
        JScrollPane jScrollPane3 = new JScrollPane();
        JTextArea jTextArea3 = new JTextArea();
        JSeparator jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Feature Request");
        this.setResizable(false);
        jLabel1.setFont(new Font("Tahoma", 1, 13));
        jLabel1.setText("Name *");
        jLabel2.setFont(new Font("Tahoma", 1, 13));
        jLabel2.setText("Email address *");
        this.descriptionField.setColumns(20);
        this.descriptionField.setLineWrap(true);
        this.descriptionField.setRows(5);
        this.descriptionField.setWrapStyleWord(true);
        jScrollPane1.setViewportView(this.descriptionField);
        jLabel3.setFont(new Font("Tahoma", 1, 13));
        jLabel3.setText("Description of feature *");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureRequestDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.sendButton.setText("Send Request");
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureRequestDialog.this.sendButtonActionPerformed(evt);
            }
        });
        jLabel4.setFont(new Font("Tahoma", 1, 13));
        jLabel4.setText("Institution   ");
        jLabel5.setFont(new Font("Tahoma", 1, 13));
        jLabel5.setText("Request Type *");
        this.requestTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Visualization", "Analytics", "Data Source", "File format", "Plugin", "Other"}));
        jScrollPane3.setBorder(null);
        jScrollPane3.setHorizontalScrollBarPolicy(31);
        jScrollPane3.setVerticalScrollBarPolicy(21);
        jScrollPane3.setFocusable(false);
        jScrollPane3.setOpaque(false);
        jTextArea3.setBackground(SystemColor.control);
        jTextArea3.setColumns(20);
        jTextArea3.setEditable(false);
        jTextArea3.setFont(new Font("Tahoma", 0, 13));
        jTextArea3.setLineWrap(true);
        jTextArea3.setRows(5);
        jTextArea3.setText("We are constantly thinking of ways to improve Savant. If you have a feature suggestion, please use this form to send us your idea. We will contact you once we have reviewed your request.");
        jTextArea3.setWrapStyleWord(true);
        jTextArea3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jScrollPane3.setViewportView(jTextArea3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.sendButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addComponent(jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane1, -1, 532, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGap(66, 66, 66).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jLabel4).addComponent(jLabel2).addComponent(jLabel1).addComponent(jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane3, GroupLayout.Alignment.TRAILING, -1, 532, Short.MAX_VALUE).addComponent(jSeparator1, GroupLayout.Alignment.TRAILING, -1, 532, Short.MAX_VALUE).addComponent(this.emailField, -1, 532, Short.MAX_VALUE).addComponent(this.nameField, -1, 532, Short.MAX_VALUE).addComponent(this.institutionField, GroupLayout.Alignment.TRAILING, -1, 532, Short.MAX_VALUE).addComponent(this.requestTypeCombo, 0, 532, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane3, -2, 57, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jSeparator1, -2, 10, -2).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.nameField, -2, -1, -2)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.emailField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.institutionField, -2, -1, -2).addComponent(jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent(this.requestTypeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel3, GroupLayout.Alignment.LEADING).addComponent(jScrollPane1, GroupLayout.Alignment.LEADING, -1, 270, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.sendButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void sendButtonActionPerformed(ActionEvent evt) {
        if (this.validateForm()) {
            String name = this.getPersonsName();
            String email = this.getEmail();
            String type = this.getRequestType();
            String institution = this.getInstitution();
            String description = this.getDescription();
            String subject = "[Savant Feature Request] from " + name;
            String message = "Name: " + name + "\n\n" + "Email: " + email + "\n\n" + "Type: " + type + "\n\n" + "Institution: " + institution + "\n\n" + "Description:\n" + description + "\n";
            this.sendButton.setText("Sending...");
            this.sendButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            if (Mail.sendEMailToDevelopers(name, subject, message)) {
                DialogUtils.displayMessage("Request sent. Thank you for your suggestion!");
            } else {
                DialogUtils.displayError("Error sending request. Check your internet connection or try again later.");
            }
            this.setVisible(false);
        }
    }

    private String getPersonsName() {
        return this.nameField.getText();
    }

    private String getEmail() {
        return this.emailField.getText();
    }

    private String getRequestType() {
        return (String)this.requestTypeCombo.getSelectedItem();
    }

    private String getInstitution() {
        return this.institutionField.getText();
    }

    private String getDescription() {
        return this.descriptionField.getText();
    }

    private boolean validateForm() {
        if (this.getPersonsName().equals("")) {
            DialogUtils.displayMessage("Please enter your name.");
            this.nameField.requestFocus();
            return false;
        }
        if (!this.getEmail().contains("@")) {
            DialogUtils.displayMessage("Please enter a valid email address.");
            this.emailField.requestFocus();
            return false;
        }
        if (this.getDescription().equals("")) {
            DialogUtils.displayMessage("Please enter a description of the feature.");
            this.descriptionField.requestFocus();
            return false;
        }
        return true;
    }
}

