/*
 * Decompiled with CFR 0.152.
 */
package savant.view.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.DataSourceAdapter;
import savant.api.data.DataFormat;
import savant.api.util.DialogUtils;
import savant.controller.DataSourcePluginController;
import savant.controller.FrameController;
import savant.controller.GenomeController;
import savant.controller.ProjectController;
import savant.data.types.Genome;
import savant.view.dialog.DataSourcePluginDialog;
import savant.view.dialog.OpenURLDialog;
import savant.view.swing.Savant;
import savant.view.tracks.Track;
import savant.view.tracks.TrackFactory;

public class LoadGenomeDialog
extends JDialog {
    private static final Log LOG = LogFactory.getLog(LoadGenomeDialog.class);
    private File lastTrackDirectory;
    private JPanel auxiliaryPanel;
    private JButton fromFileButton;
    private JButton fromOtherButton;
    private JButton fromURLButton;
    private JComboBox genomesCombo;
    private JTextField lengthField;
    private JTextField nameField;
    private JButton okButton;
    private JRadioButton publishedGenomeRadio;
    private JRadioButton userSpecifiedRadio;
    private ButtonGroup withoutSequenceButtonGroup;

    public LoadGenomeDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        if (DataSourcePluginController.getInstance().hasOnlySavantRepoDataSource()) {
            this.fromOtherButton.setText("Repository");
        }
        this.initDropDowns();
        this.updateEnabledControls();
        this.getRootPane().setDefaultButton(this.okButton);
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.withoutSequenceButtonGroup = new ButtonGroup();
        JLabel fromLabel = new JLabel();
        this.fromFileButton = new JButton();
        this.fromURLButton = new JButton();
        this.fromOtherButton = new JButton();
        JSeparator jSeparator1 = new JSeparator();
        this.publishedGenomeRadio = new JRadioButton();
        JLabel speciesLabel = new JLabel();
        this.genomesCombo = new JComboBox();
        this.auxiliaryPanel = new JPanel();
        JSeparator jSeparator2 = new JSeparator();
        this.userSpecifiedRadio = new JRadioButton();
        JLabel nameLabel = new JLabel();
        this.nameField = new JTextField();
        JLabel lengthLabel = new JLabel();
        this.lengthField = new JTextField();
        JSeparator jSeparator3 = new JSeparator();
        this.okButton = new JButton();
        JButton cancelButton = new JButton();
        this.withoutSequenceButtonGroup.add(this.publishedGenomeRadio);
        this.withoutSequenceButtonGroup.add(this.userSpecifiedRadio);
        this.setDefaultCloseOperation(2);
        this.setTitle("Load Genome");
        this.getContentPane().setLayout(new GridBagLayout());
        fromLabel.setText("Load from:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(30, 30, 3, 3);
        this.getContentPane().add((Component)fromLabel, gridBagConstraints);
        this.fromFileButton.setText("File");
        this.fromFileButton.setPreferredSize(new Dimension(150, 29));
        this.fromFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadGenomeDialog.this.fromFileButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.fromFileButton, gridBagConstraints);
        this.fromURLButton.setText("URL");
        this.fromURLButton.setPreferredSize(new Dimension(150, 29));
        this.fromURLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadGenomeDialog.this.fromURLButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.fromURLButton, gridBagConstraints);
        this.fromOtherButton.setText("Other Datasource");
        this.fromOtherButton.setPreferredSize(new Dimension(150, 29));
        this.fromOtherButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadGenomeDialog.this.fromOtherButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.fromOtherButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 9;
        gridBagConstraints.ipady = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 15, 3, 15);
        this.getContentPane().add((Component)jSeparator1, gridBagConstraints);
        this.publishedGenomeRadio.setSelected(true);
        this.publishedGenomeRadio.setText("Published Genome");
        this.publishedGenomeRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadGenomeDialog.this.publishedGenomeRadioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 30, 3, 3);
        this.getContentPane().add((Component)this.publishedGenomeRadio, gridBagConstraints);
        speciesLabel.setText("Genome:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 30, 3, 3);
        this.getContentPane().add((Component)speciesLabel, gridBagConstraints);
        this.genomesCombo.setToolTipText("Species of a published genome to load");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 30);
        this.getContentPane().add((Component)this.genomesCombo, gridBagConstraints);
        this.auxiliaryPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.ipady = 30;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 30);
        this.getContentPane().add((Component)this.auxiliaryPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 9;
        gridBagConstraints.ipady = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 15, 3, 15);
        this.getContentPane().add((Component)jSeparator2, gridBagConstraints);
        this.userSpecifiedRadio.setText("User-specified");
        this.userSpecifiedRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadGenomeDialog.this.userSpecifiedRadioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 30, 3, 3);
        this.getContentPane().add((Component)this.userSpecifiedRadio, gridBagConstraints);
        nameLabel.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)nameLabel, gridBagConstraints);
        this.nameField.setToolTipText("Name of reference (must correspond to name in records)");
        this.nameField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 90);
        this.getContentPane().add((Component)this.nameField, gridBagConstraints);
        lengthLabel.setText("Length:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)lengthLabel, gridBagConstraints);
        this.lengthField.setToolTipText("Length in basepairs of reference");
        this.lengthField.setEnabled(false);
        this.lengthField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LoadGenomeDialog.this.lengthFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 150);
        this.getContentPane().add((Component)this.lengthField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 9;
        gridBagConstraints.ipady = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 15, 3, 15);
        this.getContentPane().add((Component)jSeparator3, gridBagConstraints);
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(90, 29));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadGenomeDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 30, 30);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        cancelButton.setText("Cancel");
        cancelButton.setPreferredSize(new Dimension(90, 29));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadGenomeDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 30, 3);
        this.getContentPane().add((Component)cancelButton, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (!this.userSpecifiedRadio.isSelected() && !this.publishedGenomeRadio.isSelected()) {
            return;
        }
        if (this.userSpecifiedRadio.isSelected() && !this.validateUserSpecifiedLength()) {
            return;
        }
        this.setVisible(false);
        boolean usingPublished = this.publishedGenomeRadio.isSelected();
        if (usingPublished) {
            Genome genome = (Genome)this.genomesCombo.getSelectedItem();
            try {
                ArrayList<URI> trackURIs = new ArrayList<URI>();
                Genome.Auxiliary[] auxes = genome.getAuxiliaries();
                for (int i = 0; i < auxes.length; ++i) {
                    if (!((JCheckBox)this.auxiliaryPanel.getComponent(i)).isSelected()) continue;
                    trackURIs.add(auxes[i].uri);
                }
                ProjectController.getInstance().setProjectFromGenome(genome, trackURIs.toArray(new URI[0]));
            }
            catch (Throwable x) {
                DialogUtils.displayException("Error Loading Genome", String.format("<html>Unable to load genome for <i>%s</i>.</html>", genome), x);
            }
        } else {
            Genome genome = new Genome(this.nameField.getText(), Integer.parseInt(this.lengthField.getText()));
            GenomeController.getInstance().setGenome(genome);
        }
    }

    private void lengthFieldFocusLost(FocusEvent evt) {
    }

    private void publishedGenomeRadioActionPerformed(ActionEvent evt) {
        this.updateEnabledControls();
    }

    private void userSpecifiedRadioActionPerformed(ActionEvent evt) {
        this.updateEnabledControls();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void fromOtherButtonActionPerformed(ActionEvent evt) {
        try {
            DataSourceAdapter s = DataSourcePluginDialog.getDataSource(this);
            if (s != null) {
                this.setVisible(false);
                Track t = TrackFactory.createTrack(s);
                FrameController.getInstance().createFrame(new Track[]{t});
                GenomeController.getInstance().setGenome(Genome.createFromTrack(t));
            }
        }
        catch (Exception x) {
            DialogUtils.displayException("Error Loading Genome", "Unable to load genome from the plugin datasource.", x);
        }
    }

    private void fromURLButtonActionPerformed(ActionEvent evt) {
        URL url = OpenURLDialog.getURL(this);
        if (url != null) {
            try {
                this.setVisible(false);
                ProjectController projectController = ProjectController.getInstance();
                if (projectController.promptToSaveChanges(false)) {
                    projectController.clearExistingProject();
                    GenomeController.getInstance().setGenome(null);
                    FrameController.getInstance().addTrackFromURI(url.toURI(), DataFormat.SEQUENCE, null);
                }
            }
            catch (Throwable x) {
                DialogUtils.displayException("Error Loading Genome", String.format("Unable to load genome from %s.", url), x);
            }
        }
    }

    private void fromFileButtonActionPerformed(ActionEvent evt) {
        File selectedFile = DialogUtils.chooseFileForOpen("Load Genome", null, this.lastTrackDirectory);
        if (selectedFile != null) {
            try {
                this.setVisible(false);
                ProjectController projectController = ProjectController.getInstance();
                if (projectController.promptToSaveChanges(false)) {
                    projectController.clearExistingProject();
                    GenomeController.getInstance().setGenome(null);
                    Savant.getInstance().setLastTrackDirectory(selectedFile.getParentFile());
                    FrameController.getInstance().addTrackFromPath(selectedFile.getAbsolutePath(), DataFormat.SEQUENCE, null);
                }
            }
            catch (Throwable x) {
                DialogUtils.displayException("Error Loading Genome", String.format("Unable to load genome from %s.", selectedFile.getName()), x);
            }
        }
    }

    private void initDropDowns() {
        this.genomesCombo.setModel(new DefaultComboBoxModel<Genome>(Genome.getDefaultGenomes()));
        this.genomesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadGenomeDialog.this.updateAuxiliaryList();
            }
        });
        this.updateAuxiliaryList();
    }

    private void updateAuxiliaryList() {
        Genome curGenome = (Genome)this.genomesCombo.getSelectedItem();
        this.auxiliaryPanel.removeAll();
        Genome.Auxiliary[] auxes = curGenome.getAuxiliaries();
        if (auxes.length > 0) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridwidth = 0;
            gbc.gridy = -1;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            for (Genome.Auxiliary aux : auxes) {
                JCheckBox cb = new JCheckBox(aux.toString());
                cb.setSelected(aux.type == Genome.AuxiliaryType.SEQUENCE);
                this.auxiliaryPanel.add((Component)cb, gbc);
            }
        }
        this.pack();
    }

    private void updateEnabledControls() {
        boolean usingPublished = this.publishedGenomeRadio.isSelected();
        this.genomesCombo.setEnabled(usingPublished);
        for (Component c : this.auxiliaryPanel.getComponents()) {
            c.setEnabled(usingPublished);
        }
        this.lengthField.setEnabled(!usingPublished);
        this.nameField.setEnabled(!usingPublished);
    }

    private boolean validateUserSpecifiedLength() {
        String refname = this.nameField.getText();
        if (refname.equals("")) {
            DialogUtils.displayError("Invalid name.");
            this.nameField.requestFocus();
            return false;
        }
        String text = this.lengthField.getText();
        try {
            int i = Integer.parseInt(text);
            if (i <= 0) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            DialogUtils.displayError("Invalid length.");
            this.lengthField.requestFocus();
            return false;
        }
        return true;
    }

    public void setFromFileDirectory(File lastTrackDirectory) {
        this.lastTrackDirectory = lastTrackDirectory;
    }
}

