/*
 * Decompiled with CFR 0.152.
 */
package savant.view.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.util.DialogUtils;
import savant.plugin.PluginController;
import savant.settings.BrowserSettings;
import savant.settings.DirectorySettings;
import savant.util.MiscUtils;
import savant.util.NetworkUtils;
import savant.view.dialog.PluginBrowser;
import savant.view.dialog.PluginRepositoryDialog;

public class PluginManagerDialog
extends JDialog {
    private static Log LOG = LogFactory.getLog(PluginManagerDialog.class);
    private static PluginManagerDialog instance;
    private PluginBrowser browser;
    private PluginRepositoryDialog repositoryBrowser;
    private JPanel browserPanel;
    private JButton closeButton;

    public static PluginManagerDialog getInstance() {
        if (instance == null) {
            instance = new PluginManagerDialog(DialogUtils.getMainWindow());
        }
        return instance;
    }

    private PluginManagerDialog(Window parent) {
        super(parent, "Plugin Manager", Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        MiscUtils.registerCancelButton(this.closeButton);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        this.browser = new PluginBrowser();
        this.browserPanel.add((Component)new JScrollPane((Component)((Object)this.browser)), "Center");
    }

    private void initComponents() {
        JLabel pluginsCaption = new JLabel();
        JButton fromFileButton = new JButton();
        JButton fromRepositoryButton = new JButton();
        this.browserPanel = new JPanel();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setIconImage(null);
        this.setIconImages(null);
        pluginsCaption.setText("Installed Plugins");
        fromFileButton.setText("Install from File");
        fromFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginManagerDialog.this.fromFileButtonActionPerformed(evt);
            }
        });
        fromRepositoryButton.setText("Install from Repository");
        fromRepositoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginManagerDialog.this.fromRepositoryButtonActionPerformed(evt);
            }
        });
        this.browserPanel.setBackground(new Color(255, 255, 255));
        this.browserPanel.setLayout(new BorderLayout());
        this.closeButton.setText("Dismiss");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginManagerDialog.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browserPanel, -1, 549, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(pluginsCaption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 302, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.closeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(fromRepositoryButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(fromFileButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(pluginsCaption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browserPanel, -1, 243, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(fromFileButton).addComponent(this.closeButton).addComponent(fromRepositoryButton)).addContainerGap()));
        this.pack();
    }

    private void fromFileButtonActionPerformed(ActionEvent evt) {
        File selectedFile = DialogUtils.chooseFileForOpen("Select Plugin JAR", null, null);
        if (selectedFile != null) {
            try {
                PluginController.getInstance().installPlugin(selectedFile);
            }
            catch (Throwable x) {
                DialogUtils.displayException("Installation Error", String.format("<html>Unable to install plugin from <i>%s</i>: %s.</html>", selectedFile.getName(), x), x);
            }
        }
    }

    private void fromRepositoryButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.repositoryBrowser == null) {
                File file = NetworkUtils.downloadFile(BrowserSettings.PLUGIN_URL, DirectorySettings.getTmpDirectory(), null);
                this.repositoryBrowser = new PluginRepositoryDialog((Window)this, "Install Plugins", "Install", file);
            }
            this.repositoryBrowser.setVisible(true);
        }
        catch (Exception x) {
            DialogUtils.displayException("Installation Error", String.format("<html>Problem downloading file <i>%s</i>.</html>", BrowserSettings.PLUGIN_URL), x);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

