/*
 * Decompiled with CFR 0.152.
 */
package savant.view.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import savant.api.util.DialogUtils;
import savant.controller.FrameController;
import savant.controller.GenomeController;
import savant.controller.GraphPaneController;
import savant.controller.LocationController;
import savant.util.FileExtensionFilter;
import savant.util.MiscUtils;
import savant.util.swing.TrackChooser;
import savant.view.swing.Frame;

public class ExportImage {
    public ExportImage() {
        int defaultBase = -1;
        if (GraphPaneController.getInstance().isPlumbing()) {
            defaultBase = GraphPaneController.getInstance().getMouseXPosition();
        }
        TrackChooser tc = new TrackChooser(DialogUtils.getMainWindow(), true, "Select Tracks to Export", true, defaultBase);
        tc.setVisible(true);
        String[] trackNames = tc.getSelectedTracks();
        int base = tc.getBaseSelected();
        if (trackNames == null) {
            return;
        }
        BufferedImage bf = ExportImage.beginExport(trackNames, base);
        if (bf == null) {
            return;
        }
        this.save(bf);
    }

    public static BufferedImage beginExport(String[] trackNames, int base) {
        List<Frame> frames = FrameController.getInstance().getFrames();
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        int totalWidth = 0;
        int totalHeight = 45;
        block0: for (int j = 0; j < trackNames.length; ++j) {
            for (int i = 0; i < frames.size(); ++i) {
                if (!frames.get(i).getName().equals(trackNames[j])) continue;
                BufferedImage im = frames.get(i).frameToImage(base);
                images.add(im);
                totalWidth = Math.max(totalWidth, im.getWidth());
                totalHeight += im.getHeight();
                trackNames[j] = null;
                continue block0;
            }
        }
        if (images.isEmpty()) {
            return null;
        }
        BufferedImage out = new BufferedImage(totalWidth, totalHeight, 1);
        LocationController lc = LocationController.getInstance();
        int start = lc.getRangeStart();
        int end = lc.getRangeEnd();
        String toWrite = "Genome:  " + GenomeController.getInstance().getGenome().getName() + "    Reference:  " + lc.getReferenceName() + "    Range:  " + start + " - " + end;
        Graphics2D g = out.createGraphics();
        g.setColor(Color.white);
        g.setFont(new Font(null, 1, 13));
        g.drawString(toWrite, 2, 17);
        int outX = 0;
        int outY = 25;
        for (int i = 0; i < images.size(); ++i) {
            BufferedImage current = (BufferedImage)images.get(i);
            for (int y = 0; y < current.getHeight(); ++y) {
                for (int x = 0; x < current.getWidth(); ++x) {
                    int color = current.getRGB(x, y);
                    out.setRGB(outX, outY, color);
                    ++outX;
                }
                outX = 0;
                ++outY;
            }
        }
        toWrite = "Generated using the Savant Genome Browser - http://savantbrowser.com";
        g.setColor(Color.white);
        g.setFont(new Font(null, 1, 10));
        g.drawString(toWrite, 2, outY + 14);
        return out;
    }

    private void save(BufferedImage screen) {
        File selectedFile = DialogUtils.chooseFileForSave("Output File", "Untitled.png", new FileExtensionFilter("Image files", "png"), null);
        if (selectedFile != null) {
            String selectedPath = selectedFile.getAbsolutePath();
            if (!MiscUtils.getExtension(selectedPath).equals("png")) {
                selectedFile = new File(selectedPath + ".png");
            }
            try {
                ImageIO.write((RenderedImage)screen, "PNG", selectedFile);
            }
            catch (IOException ex) {
                DialogUtils.displayException("Sorry", "Unable to take screenshot.", ex);
            }
        }
    }
}

