/*
 * Decompiled with CFR 0.152.
 */
package savant.view.swing.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import savant.util.Bookmark;
import savant.util.Range;

public class BookmarksTableModel
extends AbstractTableModel {
    private Class[] columnClasses = new Class[]{String.class, Integer.class, Integer.class, String.class};
    private String[] columnNames = new String[]{"Reference", "From", "To", "Annotation"};
    protected List<Bookmark> data;

    public BookmarksTableModel() {
        this(new ArrayList<Bookmark>());
    }

    public BookmarksTableModel(List<Bookmark> data) {
        this.data = data;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Class getColumnClass(int column) {
        return this.columnClasses[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        Bookmark fave = this.data.get(row);
        switch (column) {
            case 0: {
                return fave.getReference();
            }
            case 1: {
                return fave.getRange().getFrom();
            }
            case 2: {
                return fave.getRange().getTo();
            }
            case 3: {
                return fave.getAnnotation();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        Bookmark fave = this.data.get(row);
        switch (column) {
            case 0: {
                fave.setReference((String)value);
                break;
            }
            case 1: {
                Range r1 = (Range)fave.getRange();
                Range newr1 = new Range((Integer)value, r1.getTo());
                fave.setRange(newr1);
                break;
            }
            case 2: {
                Range r2 = (Range)fave.getRange();
                Range newr2 = new Range(r2.getFrom(), (Integer)value);
                fave.setRange(newr2);
                break;
            }
            case 3: {
                fave.setAnnotation((String)value);
                break;
            }
        }
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public int getRowCount() {
        if (!this.isData()) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public boolean hasEmptyRow() {
        if (this.data.size() == 0) {
            return false;
        }
        Bookmark fave = this.data.get(this.data.size() - 1);
        return fave.getRange().getFrom() == 0 && fave.getRange().getTo() == 0;
    }

    public void addEmptyRow() {
        this.data.add(new Bookmark("", new Range(0, 0)));
        this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
    }

    public boolean isData() {
        return this.data != null;
    }

    public void setData(List<Bookmark> favorites) {
        this.data = favorites;
        this.fireTableChanged(null);
    }

    public List<Bookmark> getData() {
        return this.data;
    }

    public void clearData() {
        this.data.clear();
    }
}

