/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.data.Interval;
import savant.api.data.IntervalRecord;
import savant.api.data.Record;
import savant.api.util.Resolution;
import savant.exception.SavantTrackCreationCancelledException;
import savant.settings.ResolutionSettings;
import savant.util.AxisRange;
import savant.util.AxisType;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.DrawingMode;
import savant.util.Range;
import savant.view.tracks.IntervalTrackRenderer;
import savant.view.tracks.Track;

public class IntervalTrack
extends Track {
    private static Log LOG = LogFactory.getLog(IntervalTrack.class);

    public IntervalTrack(DataSourceAdapter intervalTrack) throws SavantTrackCreationCancelledException {
        super(intervalTrack, new IntervalTrackRenderer());
        this.drawingMode = DrawingMode.PACK;
    }

    @Override
    public ColourScheme getDefaultColourScheme() {
        return new ColourScheme(ColourKey.TRANSLUCENT_GRAPH, ColourKey.OPAQUE_GRAPH, ColourKey.INTERVAL_LINE);
    }

    @Override
    public Resolution getResolution(RangeAdapter range) {
        return this.getResolution((Range)range, this.getDrawingMode());
    }

    public Resolution getResolution(Range range, DrawingMode mode) {
        switch (mode) {
            case SQUISH: {
                return IntervalTrack.getSquishModeResolution(range);
            }
            case ARC: {
                return IntervalTrack.getArcModeResolution(range);
            }
            case PACK: {
                return IntervalTrack.getDefaultModeResolution(range);
            }
        }
        LOG.warn((Object)("Unrecognized draw mode " + (Object)((Object)mode)));
        return IntervalTrack.getDefaultModeResolution(range);
    }

    @Override
    public DrawingMode[] getValidDrawingModes() {
        return new DrawingMode[]{DrawingMode.PACK, DrawingMode.SQUISH, DrawingMode.ARC};
    }

    @Override
    public AxisType getYAxisType(Resolution r) {
        return this.getDrawingMode() == DrawingMode.ARC ? AxisType.INTEGER : AxisType.INTEGER_GRIDLESS;
    }

    public static Resolution getDefaultModeResolution(Range range) {
        return range.getLength() > ResolutionSettings.getIntervalLowToHighThreshold() ? Resolution.LOW : Resolution.HIGH;
    }

    public static Resolution getArcModeResolution(Range range) {
        return range.getLength() > ResolutionSettings.getIntervalLowToHighThreshold() ? Resolution.LOW : Resolution.HIGH;
    }

    public static Resolution getSquishModeResolution(Range range) {
        return range.getLength() > ResolutionSettings.getIntervalLowToHighThreshold() ? Resolution.LOW : Resolution.HIGH;
    }

    @Override
    public void prepareForRendering(String ref, Range r) {
        Resolution res = this.getResolution(r);
        switch (res) {
            case HIGH: {
                this.renderer.addInstruction(DrawingInstruction.PROGRESS, "Retrieving data...");
                this.requestData(ref, r);
                break;
            }
            default: {
                this.renderer.addInstruction(DrawingInstruction.ERROR, ZOOM_MESSAGE);
            }
        }
        this.renderer.addInstruction(DrawingInstruction.RESOLUTION, (Object)res);
        this.renderer.addInstruction(DrawingInstruction.RANGE, r);
        this.renderer.addInstruction(DrawingInstruction.COLOUR_SCHEME, this.getColourScheme());
        this.renderer.addInstruction(DrawingInstruction.REFERENCE_EXISTS, this.containsReference(ref));
        if (this.getDrawingMode() != DrawingMode.ARC) {
            this.renderer.addInstruction(DrawingInstruction.AXIS_RANGE, new AxisRange(r, new Range(0, 1)));
        }
        this.renderer.addInstruction(DrawingInstruction.MODE, (Object)this.getDrawingMode());
        this.renderer.addInstruction(DrawingInstruction.SELECTION_ALLOWED, true);
    }

    public static int getMaxValue(List<Record> data) {
        double max = 0.0;
        for (Record r : data) {
            Interval interval = ((IntervalRecord)r).getInterval();
            double val = interval.getLength();
            if (!(val > max)) continue;
            max = val;
        }
        return (int)Math.ceil(max);
    }
}

