/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import savant.api.adapter.GraphPaneAdapter;
import savant.api.data.Interval;
import savant.api.data.IntervalRecord;
import savant.api.data.Record;
import savant.api.event.DataRetrievalEvent;
import savant.api.util.Resolution;
import savant.exception.RenderingException;
import savant.util.AxisRange;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.DrawingMode;
import savant.util.IntervalPacker;
import savant.util.Range;
import savant.view.tracks.IntervalTrack;
import savant.view.tracks.TrackRenderer;

public class IntervalTrackRenderer
extends TrackRenderer {
    @Override
    public void handleEvent(DataRetrievalEvent evt) {
        switch (evt.getType()) {
            case COMPLETED: {
                DrawingMode mode = (DrawingMode)((Object)this.instructions.get((Object)DrawingInstruction.MODE));
                if (mode != DrawingMode.ARC) break;
                int maxDataValue = IntervalTrack.getMaxValue(evt.getData());
                Range range = (Range)this.instructions.get((Object)DrawingInstruction.RANGE);
                this.addInstruction(DrawingInstruction.AXIS_RANGE, new AxisRange(range, new Range(0, (int)Math.round(Math.log(maxDataValue)))));
            }
        }
        super.handleEvent(evt);
    }

    @Override
    public void render(Graphics2D g2, GraphPaneAdapter gp) throws RenderingException {
        this.renderPreCheck();
        DrawingMode mode = (DrawingMode)((Object)this.instructions.get((Object)DrawingInstruction.MODE));
        Resolution r = (Resolution)((Object)this.instructions.get((Object)DrawingInstruction.RESOLUTION));
        if (mode == DrawingMode.SQUISH) {
            this.renderSquishMode(g2, gp, r);
        } else if (mode == DrawingMode.ARC) {
            this.renderArcMode(g2, gp, r);
        } else if (mode == DrawingMode.PACK) {
            this.renderPackMode(g2, gp, r);
        }
        if (this.data.isEmpty()) {
            throw new RenderingException("No data in range", 1);
        }
    }

    private void renderSquishMode(Graphics2D g2, GraphPaneAdapter gp, Resolution r) throws RenderingException {
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        Color bgcolor = cs.getColor(ColourKey.TRANSLUCENT_GRAPH);
        Color linecolor = cs.getColor(ColourKey.INTERVAL_LINE);
        AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
        if (r == Resolution.HIGH) {
            gp.setXRange(axisRange.getXRange());
            gp.setYRange(axisRange.getYRange());
            double unitWidth = gp.getUnitWidth();
            double unitHeight = gp.getUnitHeight();
            double y = gp.transformYPos(0.0);
            for (Record record : this.data) {
                Interval inter = ((IntervalRecord)record).getInterval();
                double x = gp.transformXPos(inter.getStart());
                double w = unitWidth * (double)inter.getLength();
                double h = unitHeight;
                Rectangle2D.Double rect = new Rectangle2D.Double(x, y - unitHeight, w, unitHeight);
                g2.setColor(bgcolor);
                g2.fill(rect);
                if (!(w > 5.0)) continue;
                g2.setColor(linecolor);
                g2.draw(rect);
            }
        } else {
            throw new RenderingException("Zoom in to see intervals", 0);
        }
    }

    private void renderArcMode(Graphics2D g2, GraphPaneAdapter gp, Resolution r) {
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        Color bgcolor = cs.getColor(ColourKey.OPAQUE_GRAPH);
        AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
        if (r == Resolution.HIGH) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gp.setXRange(axisRange.getXRange());
            gp.setYRange(axisRange.getYRange());
            for (Record record : this.data) {
                Interval inter = ((IntervalRecord)record).getInterval();
                int arcLength = inter.getLength();
                double arcHeight = Math.log(arcLength);
                double rectWidth = (double)arcLength * gp.getUnitWidth();
                double rectHeight = arcHeight * 2.0 * gp.getUnitHeight();
                double xOrigin = gp.transformXPos(inter.getStart());
                double yOrigin = gp.transformYPos(arcHeight);
                g2.setColor(bgcolor);
                g2.draw(new Arc2D.Double(xOrigin, yOrigin, rectWidth, rectHeight, -180.0, -180.0, 0));
            }
        }
    }

    private void renderPackMode(Graphics2D g2, GraphPaneAdapter gp, Resolution r) throws RenderingException {
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
        if (r == Resolution.HIGH) {
            IntervalPacker packer = new IntervalPacker(this.data);
            List<List<IntervalRecord>> intervals = packer.pack(2);
            gp.setXRange(axisRange.getXRange());
            int numIntervals = intervals.size();
            int maxYRange = numIntervals <= 10 ? 10 : (numIntervals <= 20 ? 20 : (numIntervals <= 50 ? 50 : (numIntervals <= 100 ? 100 : numIntervals)));
            gp.setYRange(new Range(0, maxYRange));
            if (gp.needsToResize()) {
                return;
            }
            double unitHeight = gp.getUnitHeight();
            double unitWidth = gp.getUnitWidth();
            int offset = gp.getOffset();
            Color textColor = cs.getColor(ColourKey.INTERVAL_TEXT);
            Color bgColor = cs.getColor(ColourKey.OPAQUE_GRAPH);
            Color lineColor = cs.getColor(ColourKey.INTERVAL_LINE);
            for (int k = 0; k < intervals.size(); ++k) {
                List<IntervalRecord> intervalsThisLevel = intervals.get(k);
                for (IntervalRecord intervalRecord : intervalsThisLevel) {
                    String geneName;
                    Interval interval = intervalRecord.getInterval();
                    double x = gp.transformXPos(interval.getStart());
                    double y = (double)gp.getHeight() - unitHeight * (double)(k + 1) - (double)offset;
                    double w = (double)interval.getLength() * unitWidth;
                    double h = unitHeight;
                    Rectangle2D.Double intervalRect = new Rectangle2D.Double(x, y, w, h);
                    g2.setColor(bgColor);
                    g2.fill(intervalRect);
                    this.recordToShapeMap.put(intervalRecord, intervalRect);
                    if (w > 5.0) {
                        g2.setColor(lineColor);
                        g2.draw(intervalRect);
                    }
                    if ((geneName = intervalRecord.getName()) == null) continue;
                    g2.setColor(textColor);
                    FontMetrics fm = g2.getFontMetrics();
                    this.drawFeatureLabel(g2, geneName, x, y + unitHeight * 0.5 + (double)(fm.getHeight() - fm.getDescent()) * 0.5);
                }
            }
        }
    }
}

