/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import savant.api.adapter.GraphPaneAdapter;
import savant.api.data.PointRecord;
import savant.api.data.Record;
import savant.api.util.Resolution;
import savant.exception.RenderingException;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.view.tracks.TrackRenderer;

public class PointTrackRenderer
extends TrackRenderer {
    @Override
    public void render(Graphics2D g2, GraphPaneAdapter gp) throws RenderingException {
        this.renderPreCheck();
        Resolution r = (Resolution)((Object)this.instructions.get((Object)DrawingInstruction.RESOLUTION));
        double width = gp.getUnitWidth();
        if (width < 0.5 || this.data == null) {
            throw new RenderingException("Zoom in to see points", 0);
        }
        if (r == Resolution.HIGH) {
            ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
            Color bgcolor = cs.getColor(ColourKey.POINT_FILL);
            Color linecolor = cs.getColor(ColourKey.POINT_LINE);
            for (Record record : this.data) {
                Polygon p = new Polygon();
                int sp = ((PointRecord)record).getPosition();
                Point2D.Double p1 = new Point2D.Double(gp.transformXPos(sp), 0.0);
                Point2D.Double p2 = new Point2D.Double(gp.transformXPos(sp + 1), 0.0);
                Point2D.Double p3 = new Point2D.Double(gp.transformXPos(sp + 1), gp.getHeight());
                Point2D.Double p4 = new Point2D.Double(gp.transformXPos(sp), gp.getHeight());
                p.addPoint((int)p1.x, (int)p1.y);
                p.addPoint((int)p2.x, (int)p2.y);
                p.addPoint((int)p3.x, (int)p3.y);
                p.addPoint((int)p4.x, (int)p4.y);
                g2.setColor(bgcolor);
                g2.fillPolygon(p);
                this.recordToShapeMap.put(record, p);
                if (!(width > 5.0)) continue;
                g2.setColor(linecolor);
                g2.drawPolygon(p);
            }
        }
        if (this.data.isEmpty()) {
            throw new RenderingException("No data in range", 1);
        }
    }
}

