/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.UnsupportedEncodingException;
import savant.api.adapter.GraphPaneAdapter;
import savant.api.data.SequenceRecord;
import savant.api.util.Resolution;
import savant.exception.RenderingException;
import savant.util.AxisRange;
import savant.util.ColourAccumulator;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.DrawingMode;
import savant.view.tracks.TrackRenderer;

public class SequenceTrackRenderer
extends TrackRenderer {
    private static final Font SMALL_BASE_FONT = new Font("Sans-Serif", 0, 12);
    private static final Font LARGE_BASE_FONT = new Font("Sans-Serif", 0, 36);

    @Override
    public void render(Graphics2D g2, GraphPaneAdapter gp) throws RenderingException {
        double x;
        int i;
        this.renderPreCheck();
        double unitWidth = gp.getUnitWidth();
        byte[] sequence = ((SequenceRecord)this.data.get(0)).getSequence();
        boolean baseRenderable = false;
        if (this.fontFits(LARGE_BASE_FONT, unitWidth, g2)) {
            g2.setFont(LARGE_BASE_FONT);
            baseRenderable = true;
        } else if (this.fontFits(SMALL_BASE_FONT, unitWidth, g2)) {
            g2.setFont(SMALL_BASE_FONT);
            baseRenderable = true;
        }
        AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        ColourAccumulator accumulator = new ColourAccumulator(cs);
        int len = sequence.length;
        for (i = 0; i < len; ++i) {
            x = gp.transformXPos(axisRange.getXMin() + i);
            accumulator.addBaseShape((char)sequence[i], new Rectangle2D.Double(x, 0.0, unitWidth, gp.getHeight()));
        }
        accumulator.fill(g2);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(0.25f));
        for (i = 0; i < len; ++i) {
            x = gp.transformXPos(axisRange.getXMin() + i);
            double y = 0.0;
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y, unitWidth, gp.getHeight());
            if (unitWidth > 12.0) {
                g2.draw(rect);
            }
            try {
                String base = new String(sequence, i, 1, "ISO-8859-1");
                if (!baseRenderable) continue;
                Font font = g2.getFont();
                Rectangle2D charRect = font.getStringBounds(base, g2.getFontRenderContext());
                float charX = (float)(rect.getX() + (rect.getWidth() - charRect.getWidth()) / 2.0);
                float charY = (float)((rect.getHeight() - 5.0) / 2.0 + (double)(g2.getFontMetrics().getAscent() / 2));
                g2.drawString(base, charX, charY);
                continue;
            }
            catch (UnsupportedEncodingException ignored) {
                // empty catch block
            }
        }
    }

    private boolean fontFits(Font font, double width, Graphics2D g2) {
        String baseChar = "G";
        Rectangle2D charRect = font.getStringBounds(baseChar, g2.getFontRenderContext());
        return !(charRect.getWidth() > width);
    }

    @Override
    public Dimension getLegendSize(DrawingMode ignored) {
        Resolution res = (Resolution)((Object)this.getInstruction(DrawingInstruction.RESOLUTION));
        return res == Resolution.HIGH ? new Dimension(150, 24) : null;
    }

    @Override
    public void drawLegend(Graphics2D g2, DrawingMode ignored) {
        this.drawBaseLegend(g2, 6, 17, ColourKey.A, ColourKey.C, ColourKey.G, ColourKey.T, ColourKey.N);
    }
}

