/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import net.sf.samtools.util.RuntimeIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.DataSourceAdapter;
import savant.api.util.DialogUtils;
import savant.controller.DataSourcePluginController;
import savant.data.sources.BAMDataSource;
import savant.data.sources.BEDDataSource;
import savant.data.sources.BigWigDataSource;
import savant.data.sources.FastaDataSource;
import savant.data.sources.GenericContinuousDataSource;
import savant.data.sources.GenericIntervalDataSource;
import savant.data.sources.GenericPointDataSource;
import savant.data.sources.OldFastaDataSource;
import savant.data.sources.TDFDataSource;
import savant.data.sources.TabixDataSource;
import savant.exception.SavantTrackCreationCancelledException;
import savant.exception.UnknownSchemeException;
import savant.file.FileType;
import savant.file.SavantFileNotFormattedException;
import savant.file.SavantROFile;
import savant.file.SavantUnsupportedFileTypeException;
import savant.file.SavantUnsupportedVersionException;
import savant.format.SavantFileFormatterUtils;
import savant.plugin.SavantDataSourcePlugin;
import savant.util.MiscUtils;
import savant.util.NetworkUtils;
import savant.view.tracks.BAMCoverageTrack;
import savant.view.tracks.BAMTrack;
import savant.view.tracks.ContinuousTrack;
import savant.view.tracks.IntervalTrack;
import savant.view.tracks.PointTrack;
import savant.view.tracks.RichIntervalTrack;
import savant.view.tracks.SequenceTrack;
import savant.view.tracks.Track;
import savant.view.tracks.TrackCreationEvent;
import savant.view.tracks.VariantTrack;

public class TrackFactory {
    private static final Log LOG = LogFactory.getLog(Track.class);

    public static Track createTrack(DataSourceAdapter ds) throws SavantTrackCreationCancelledException {
        Track t;
        if (ds == null) {
            throw new IllegalArgumentException("DataSource cannot be null.");
        }
        switch (ds.getDataFormat()) {
            case SEQUENCE: {
                t = new SequenceTrack(ds);
                break;
            }
            case RICH_INTERVAL: {
                t = new RichIntervalTrack(ds);
                break;
            }
            case POINT: {
                t = new PointTrack(ds);
                break;
            }
            case CONTINUOUS: {
                t = new ContinuousTrack(ds);
                break;
            }
            case ALIGNMENT: {
                t = new BAMTrack(ds);
                break;
            }
            case GENERIC_INTERVAL: {
                t = new IntervalTrack(ds);
                break;
            }
            case VARIANT: {
                t = new VariantTrack(ds);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown data format: %s.", new Object[]{ds.getDataFormat()}));
            }
        }
        return t;
    }

    public static void createTrack(URI trackURI, TrackCreationListener l) {
        l.handleEvent(new TrackCreationEvent());
        Thread t = new Thread((Runnable)new TrackCreator(trackURI, l), "TrackCreator");
        t.start();
        try {
            t.join(1000L);
            LOG.debug((Object)"Join timed out, putting up progress-bar for track creation.");
        }
        catch (InterruptedException ix) {
            LOG.error((Object)"TrackCreator interrupted during join.", (Throwable)ix);
        }
    }

    public static DataSourceAdapter createDataSource(URI trackURI, TrackCreationListener l) throws IOException, SavantFileNotFormattedException {
        return TrackFactory.createDataSource(trackURI, SavantFileFormatterUtils.guessFileTypeFromPath(trackURI.toString()), l);
    }

    public static DataSourceAdapter createDataSource(URI trackURI, FileType fileType, TrackCreationListener l) throws IOException, SavantFileNotFormattedException {
        if (fileType == null) {
            try {
                SavantROFile trkFile = new SavantROFile(trackURI);
                trkFile.close();
                if (trkFile.getFileType() == null) {
                    throw new SavantFileNotFormattedException();
                }
                switch (trkFile.getFileType()) {
                    case SEQUENCE_FASTA: {
                        return new OldFastaDataSource(trackURI);
                    }
                    case POINT_GENERIC: {
                        return new GenericPointDataSource(trackURI);
                    }
                    case CONTINUOUS_GENERIC: {
                        return new GenericContinuousDataSource(trackURI);
                    }
                    case INTERVAL_GENERIC: {
                        return new GenericIntervalDataSource(trackURI);
                    }
                    case INTERVAL_GFF: {
                        return new GenericIntervalDataSource(trackURI);
                    }
                    case INTERVAL_BED: {
                        return new BEDDataSource(trackURI);
                    }
                }
                throw new SavantUnsupportedFileTypeException("This version of Savant does not support file type " + (Object)((Object)trkFile.getFileType()));
            }
            catch (UnknownSchemeException usx) {
                for (SavantDataSourcePlugin p : DataSourcePluginController.getInstance().getPlugins()) {
                    DataSourceAdapter ds = p.getDataSource(trackURI);
                    if (ds == null) continue;
                    return ds;
                }
                throw usx;
            }
        }
        switch (fileType) {
            case SEQUENCE_FASTA: {
                LOG.info((Object)("Opening Fasta file " + trackURI));
                return new FastaDataSource(trackURI, l);
            }
            case TABIX: {
                LOG.info((Object)("Opening Tabix file " + trackURI));
                return new TabixDataSource(trackURI);
            }
            case INTERVAL_BAM: {
                LOG.info((Object)("Opening BAM file " + trackURI));
                return new BAMDataSource(trackURI);
            }
            case CONTINUOUS_BIGWIG: {
                LOG.info((Object)("Opening BigWig file " + trackURI));
                return new BigWigDataSource(trackURI);
            }
            case CONTINUOUS_TDF: {
                LOG.info((Object)("Opening TDF file " + trackURI));
                return new TDFDataSource(trackURI);
            }
        }
        throw new SavantFileNotFormattedException();
    }

    public static interface TrackCreationListener {
        public void handleEvent(TrackCreationEvent var1);
    }

    static class TrackCreator
    implements Runnable {
        private URI trackURI;
        private final TrackCreationListener listener;

        TrackCreator(URI trackURI, TrackCreationListener l) {
            this.trackURI = trackURI;
            this.listener = l;
        }

        @Override
        public void run() {
            String uriString = this.trackURI.toString();
            FileType fileType = SavantFileFormatterUtils.guessFileTypeFromPath(uriString);
            try {
                DataSourceAdapter ds = TrackFactory.createDataSource(this.trackURI, fileType, this.listener);
                ArrayList<Track> tracks = new ArrayList<Track>(2);
                tracks.add(TrackFactory.createTrack(ds));
                if (fileType == FileType.INTERVAL_BAM) {
                    URI coverageURI = new URI(uriString + ".cov.tdf");
                    try {
                        if (NetworkUtils.exists(coverageURI)) {
                            ds = new TDFDataSource(coverageURI);
                            tracks.add(new BAMCoverageTrack(ds));
                        } else {
                            coverageURI = new URI(uriString + ".cov.savant");
                            if (NetworkUtils.exists(coverageURI)) {
                                ds = new GenericContinuousDataSource(coverageURI);
                                tracks.add(new BAMCoverageTrack(ds));
                            }
                        }
                    }
                    catch (Exception x) {
                        LOG.error((Object)("Unable to load coverage track for " + uriString), (Throwable)x);
                    }
                }
                LOG.debug((Object)("Firing trackCreationCompleted for " + tracks.get(0)));
                this.fireTrackCreationCompleted(tracks.toArray(new Track[0]), "");
            }
            catch (RuntimeIOException x) {
                LOG.error((Object)"Track creation failed.", (Throwable)x);
                this.fireTrackCreationFailed(x.getCause());
            }
            catch (SavantFileNotFormattedException x) {
                this.fireTrackCreationFailed(x);
            }
            catch (SavantTrackCreationCancelledException x) {
                this.fireTrackCreationFailed(x);
            }
            catch (Exception x) {
                LOG.error((Object)"Track creation failed.", (Throwable)x);
                this.fireTrackCreationFailed(x);
            }
        }

        private void fireTrackCreationCompleted(final Track[] tracks, final String name) {
            MiscUtils.invokeLaterIfNecessary(new Runnable(){

                @Override
                public void run() {
                    if (TrackCreator.this.listener != null) {
                        TrackCreator.this.listener.handleEvent(new TrackCreationEvent(tracks, name));
                    }
                }
            });
            for (final Track t : tracks) {
                new Thread("Dictionary Loader-" + MiscUtils.getFilenameFromPath(t.getName())){

                    @Override
                    public void run() {
                        if (TrackCreator.this.listener != null) {
                            try {
                                t.getDataSource().loadDictionary();
                            }
                            catch (Exception x) {
                                LOG.error((Object)("Unable to load dictionary for " + t.getName()), (Throwable)x);
                            }
                        }
                    }
                }.start();
            }
        }

        private void fireTrackCreationFailed(final Throwable x) {
            MiscUtils.invokeLaterIfNecessary(new Runnable(){

                @Override
                public void run() {
                    if (x instanceof SavantUnsupportedFileTypeException) {
                        DialogUtils.displayMessage("Sorry", "Files of this type are not supported.");
                    } else if (x instanceof SavantFileNotFormattedException) {
                        SavantFileFormatterUtils.promptUserToFormatFile(TrackCreator.this.trackURI);
                    } else if (x instanceof SavantUnsupportedVersionException) {
                        DialogUtils.displayMessage("Sorry", "This file was created using an older version of Savant. Please re-format the source.");
                    } else if (!(x instanceof SavantTrackCreationCancelledException)) {
                        if (x instanceof FileNotFoundException) {
                            DialogUtils.displayMessage("File not found", String.format("<html>File <i>%s</i> not found.</html>", x.getMessage()));
                        } else {
                            DialogUtils.displayException("Error opening track", String.format("There was a problem opening this file: %s.", MiscUtils.getMessage(x)), x);
                        }
                    }
                    TrackCreator.this.listener.handleEvent(new TrackCreationEvent(x));
                }
            });
        }
    }
}

