/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.GraphPaneAdapter;
import savant.api.data.Record;
import savant.api.data.VariantRecord;
import savant.api.data.VariantType;
import savant.api.util.Resolution;
import savant.exception.RenderingException;
import savant.settings.ColourSettings;
import savant.util.AxisRange;
import savant.util.ColourAccumulator;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.DrawingMode;
import savant.util.Pileup;
import savant.view.tracks.TrackRenderer;

public class VariantTrackRenderer
extends TrackRenderer {
    private static final Log LOG = LogFactory.getLog(VariantTrackRenderer.class);

    VariantTrackRenderer() {
    }

    @Override
    public void render(Graphics2D g2, GraphPaneAdapter gp) throws RenderingException {
        this.renderPreCheck();
        DrawingMode mode = (DrawingMode)((Object)this.instructions.get((Object)DrawingInstruction.MODE));
        AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
        gp.setXRange(axisRange.getXRange());
        gp.setYRange(axisRange.getYRange());
        if (gp.needsToResize()) {
            return;
        }
        switch (mode) {
            case MATRIX: {
                this.renderMatrixMode(g2, gp);
                break;
            }
            case FREQUENCY: {
                this.renderFrequencyMode(g2, gp);
            }
        }
    }

    private void renderMatrixMode(Graphics2D g2, GraphPaneAdapter gp) throws RenderingException {
        double unitHeight = gp.getUnitHeight();
        double unitWidth = gp.getUnitWidth();
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        ColourAccumulator accumulator = new ColourAccumulator(cs);
        int participantCount = ((AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE)).getYMax();
        for (Record rec : this.data) {
            VariantRecord varRec = (VariantRecord)rec;
            double x = gp.transformXPos(varRec.getPosition());
            double y = (double)(participantCount - 1) * unitHeight;
            double w = Math.max(1.0, unitWidth);
            for (int j = 0; j < participantCount; ++j) {
                VariantTrackRenderer.accumulateZygoteShapes(varRec.getVariantsForParticipant(j), accumulator, new Rectangle2D.Double(x, y, w, unitHeight));
                y -= unitHeight;
            }
            this.recordToShapeMap.put(varRec, new Rectangle2D.Double(x, 0.0, w, unitHeight * (double)participantCount));
        }
        accumulator.fill(g2);
        if (unitHeight > 16.0) {
            String[] participants = (String[])this.instructions.get((Object)DrawingInstruction.PARTICIPANTS);
            double y = ((double)participants.length - 0.5) * unitHeight + 4.0;
            g2.setColor(ColourSettings.getColor(ColourKey.INTERVAL_TEXT));
            for (int i = 0; i < participants.length; ++i) {
                this.drawFeatureLabel(g2, participants[i], 0.0, y);
                y -= unitHeight;
            }
        }
    }

    public static void accumulateZygoteShapes(VariantType[] vars, ColourAccumulator accumulator, Rectangle2D rect) {
        ColourScheme scheme = accumulator.getScheme();
        if (vars != null) {
            if (vars.length == 1) {
                accumulator.addShape(scheme.getVariantColor(vars[0]), (Shape)rect);
            } else {
                Color color0 = scheme.getVariantColor(vars[0]);
                Color color1 = scheme.getVariantColor(vars[1]);
                Color blend = color0 == null ? new Color(color1.getRed(), color1.getGreen(), color1.getBlue(), 128) : (color1 == null ? new Color(color0.getRed(), color0.getGreen(), color0.getBlue(), 128) : new Color((color0.getRed() + color1.getRed()) / 2, (color0.getGreen() + color1.getGreen()) / 2, (color0.getBlue() + color1.getBlue()) / 2));
                accumulator.addShape(blend, (Shape)rect);
            }
        }
    }

    private void renderFrequencyMode(Graphics2D g2, GraphPaneAdapter gp) throws RenderingException {
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        ColourAccumulator accumulator = new ColourAccumulator(cs);
        double unitHeight = gp.getUnitHeight() / ((double)((VariantRecord)this.data.get(0)).getParticipantCount() * 2.0);
        double unitWidth = gp.getUnitWidth();
        for (int i = 0; i < this.data.size(); ++i) {
            VariantType snpNuc;
            VariantRecord varRec = (VariantRecord)this.data.get(i);
            Pileup pile = this.calculatePileup(varRec);
            double bottom = gp.transformYPos(0.0);
            double x = gp.transformXPos(varRec.getPosition());
            this.recordToShapeMap.put(varRec, new Rectangle2D.Double(x, 0.0, unitWidth, gp.getHeight()));
            while ((snpNuc = pile.getLargestVariantType(VariantType.NONE)) != null) {
                double h = (double)pile.getCoverage(snpNuc, null) * unitHeight;
                Rectangle2D.Double rect = new Rectangle2D.Double(x, bottom - h, unitWidth, h);
                accumulator.addShape(cs.getVariantColor(snpNuc), (Shape)rect);
                bottom -= h;
                pile.clearVariantType(snpNuc);
            }
        }
        accumulator.fill(g2);
    }

    private Pileup calculatePileup(VariantRecord varRec) {
        Pileup pile = new Pileup(varRec.getPosition());
        for (int j = 0; j < varRec.getParticipantCount(); ++j) {
            VariantType[] jVariants = varRec.getVariantsForParticipant(j);
            if (jVariants == null) continue;
            if (jVariants.length == 1) {
                pile.pileOn(jVariants[0], 1.0, null);
                pile.pileOn(jVariants[0], 1.0, null);
                continue;
            }
            pile.pileOn(jVariants[0], 1.0, null);
            pile.pileOn(jVariants[1], 1.0, null);
        }
        return pile;
    }

    @Override
    public Dimension getLegendSize(DrawingMode ignored) {
        Resolution res = (Resolution)((Object)this.getInstruction(DrawingInstruction.RESOLUTION));
        return res == Resolution.HIGH ? new Dimension(168, 60) : null;
    }

    @Override
    public void drawLegend(Graphics2D g2, DrawingMode ignored) {
        int x = 6;
        int y = 17;
        this.drawBaseLegend(g2, x, y, ColourKey.A, ColourKey.C, ColourKey.G, ColourKey.T);
        g2.setColor(Color.BLACK);
        g2.fillRect(x, (y += 18) - VariantTrackRenderer.SWATCH_SIZE.height + 2, VariantTrackRenderer.SWATCH_SIZE.width, VariantTrackRenderer.SWATCH_SIZE.height);
        g2.setColor(Color.BLACK);
        g2.drawString("Deletion", x + VariantTrackRenderer.SWATCH_SIZE.width + 3, y);
        g2.setColor(Color.MAGENTA);
        g2.fillRect(x += 66, y - VariantTrackRenderer.SWATCH_SIZE.height + 2, VariantTrackRenderer.SWATCH_SIZE.width, VariantTrackRenderer.SWATCH_SIZE.height);
        g2.setColor(Color.BLACK);
        g2.drawString("Insertion", x + 12, y);
        g2.drawString("Translucent = Heterozygous", 6, y += 18);
    }
}

