/*
 * Decompiled with CFR 0.152.
 */
package savant.view.variation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import savant.api.data.VariantRecord;
import savant.api.data.VariantType;
import savant.util.AggregateRecord;

public class MergedVariantRecord
implements VariantRecord,
AggregateRecord<VariantRecord> {
    private final VariantRecord original1;
    private final VariantRecord original2;
    private final int padding;
    private final String name;
    private final String[] altAlleles;
    private final byte[] renumberedAlleles;

    MergedVariantRecord(VariantRecord rec1, VariantRecord rec2, int pad) {
        this.original1 = rec1;
        this.original2 = rec2;
        this.padding = pad;
        String s = rec1.getName();
        if (s == null || s.isEmpty()) {
            s = rec2.getName();
        }
        this.name = s;
        ArrayList<String> alleles1 = new ArrayList<String>();
        alleles1.addAll(Arrays.asList(rec1.getAltAlleles()));
        String[] alleles2 = rec2.getAltAlleles();
        this.renumberedAlleles = new byte[alleles2.length + 1];
        for (int i = 0; i < alleles2.length; ++i) {
            int index = alleles1.indexOf(alleles2[i]);
            if (index < 0) {
                index = alleles1.size();
                alleles1.add(alleles2[i]);
            }
            this.renumberedAlleles[i + 1] = (byte)(index + 1);
        }
        this.altAlleles = alleles1.toArray(new String[0]);
    }

    public String toString() {
        return this.getVariantType().toString() + "@" + this.getPosition();
    }

    @Override
    public VariantType getVariantType() {
        return this.original1.getVariantType();
    }

    @Override
    public String getRefBases() {
        return this.original1.getRefBases();
    }

    @Override
    public String[] getAltAlleles() {
        return this.altAlleles;
    }

    @Override
    public int getParticipantCount() {
        return this.original1.getParticipantCount() + this.padding + this.original2.getParticipantCount();
    }

    @Override
    public VariantType[] getVariantsForParticipant(int index) {
        VariantType[] result;
        int count1 = this.original1.getParticipantCount();
        if (index < count1 && (result = this.original1.getVariantsForParticipant(index)) != null) {
            return result;
        }
        if (index >= count1 + this.padding && index < this.getParticipantCount()) {
            return this.original2.getVariantsForParticipant(index - count1 - this.padding);
        }
        return new VariantType[]{VariantType.NONE};
    }

    @Override
    public int[] getAllelesForParticipant(int index) {
        int[] result;
        int count1 = this.original1.getParticipantCount();
        if (index < count1 && (result = this.original1.getAllelesForParticipant(index)) != null) {
            return result;
        }
        if (index >= count1 + this.padding && index < this.getParticipantCount()) {
            int[] alleles2 = this.original2.getAllelesForParticipant(index - count1 - this.padding);
            if (alleles2.length == 1) {
                return new int[]{this.renumberedAlleles[alleles2[0]]};
            }
            return new int[]{this.renumberedAlleles[alleles2[0]], this.renumberedAlleles[alleles2[1]]};
        }
        return new int[]{0};
    }

    @Override
    public int getPosition() {
        return this.original1.getPosition();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getReference() {
        return this.original1.getReference();
    }

    @Override
    public boolean isPhased() {
        return this.original1.isPhased() && this.original2.isPhased();
    }

    public int compareTo(Object t) {
        VariantRecord that = (VariantRecord)t;
        return new CompareToBuilder().append((Object)this.getReference(), (Object)that.getReference()).append(this.getPosition(), that.getPosition()).append((Object)this.getRefBases(), (Object)that.getRefBases()).append((Object[])this.getAltAlleles(), (Object[])that.getAltAlleles()).toComparison();
    }

    public boolean equals(Object t) {
        if (t instanceof VariantRecord) {
            VariantRecord that = (VariantRecord)t;
            return new EqualsBuilder().append((Object)this.getReference(), (Object)that.getReference()).append(this.getPosition(), that.getPosition()).append((Object)this.getRefBases(), (Object)that.getRefBases()).append((Object[])this.getAltAlleles(), (Object[])that.getAltAlleles()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getReference()).append(this.getPosition()).append((Object)this.getRefBases()).append((Object[])this.getAltAlleles()).toHashCode();
    }

    @Override
    public List<VariantRecord> getConstituents() {
        ArrayList<VariantRecord> result = new ArrayList<VariantRecord>();
        if (this.original1 instanceof AggregateRecord) {
            result.addAll(((AggregateRecord)((Object)this.original1)).getConstituents());
        } else {
            result.add(this.original1);
        }
        if (this.original2 instanceof AggregateRecord) {
            result.addAll(((AggregateRecord)((Object)this.original2)).getConstituents());
        } else {
            result.add(this.original2);
        }
        return result;
    }
}

