/*
 * Decompiled with CFR 0.152.
 */
package savant.view.variation.swing;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import savant.api.adapter.PopupHostingAdapter;
import savant.api.data.Record;
import savant.api.data.VariantRecord;
import savant.api.data.VariantType;
import savant.api.event.PopupEvent;
import savant.api.util.Listener;
import savant.selection.PopupPanel;
import savant.util.AggregateRecord;
import savant.util.Hoverer;
import savant.view.tracks.VariantTrack;
import savant.view.variation.LDRecord;
import savant.view.variation.ParticipantRecord;
import savant.view.variation.VariationController;
import savant.view.variation.swing.VariationPlot;

public class VariantPopper
extends Hoverer
implements PopupHostingAdapter {
    VariationPlot panel;

    VariantPopper(VariationPlot vp) {
        this.panel = vp;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Record rec = this.panel.pointToRecord(this.hoverPos);
        if (rec != null) {
            PopupPanel.hidePopup();
            Point globalPos = new Point(this.hoverPos.x, this.hoverPos.y);
            SwingUtilities.convertPointToScreen(globalPos, this.panel);
            if (rec instanceof ParticipantRecord) {
                VariantType[] partVars = ((ParticipantRecord)rec).getVariants();
                if (partVars != null && partVars[0] != VariantType.NONE || partVars.length > 1 && partVars[1] != VariantType.NONE) {
                    PopupPanel.showPopup(this, globalPos, VariationController.getInstance().getTracks()[0], rec);
                }
            } else {
                PopupPanel.showPopup(this, globalPos, VariationController.getInstance().getTracks()[0], rec);
            }
        }
        this.hoverPos = null;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        VariationController.getInstance().updateStatusBar(this.panel.pointToVariantRecord(evt.getPoint()));
        Point oldHover = this.hoverPos;
        super.mouseMoved(evt);
        if (oldHover != null && !this.isHoverable(oldHover)) {
            PopupPanel.hidePopup();
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        VariationController.getInstance().navigateToRecord(this.panel.pointToVariantRecord(evt.getPoint()));
    }

    @Override
    public void addPopupListener(Listener<PopupEvent> l) {
    }

    @Override
    public void removePopupListener(Listener<PopupEvent> l) {
    }

    @Override
    public void firePopupEvent(PopupPanel panel) {
    }

    @Override
    public void popupHidden() {
    }

    @Override
    public void recordSelected(Record rec) {
        Record varRec = rec instanceof ParticipantRecord ? ((ParticipantRecord)rec).getVariantRecord() : rec;
        ArrayList<Object> selection = new ArrayList<Object>();
        if (varRec instanceof LDRecord) {
            selection.addAll(((AggregateRecord)varRec).getConstituents());
        } else if (varRec instanceof AggregateRecord) {
            selection.add(((AggregateRecord)varRec).getConstituents().get(0));
        } else {
            selection.add((VariantRecord)varRec);
        }
        for (VariantTrack t : VariationController.getInstance().getTracks()) {
            for (VariantRecord variantRecord : selection) {
                t.getRenderer().addToSelected(variantRecord);
            }
            t.repaintSelection();
        }
        VariationController.getInstance().navigateToRecord(varRec);
    }
}

