/*
 * Decompiled with CFR 0.152.
 */
package savant.view.variation.swing;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import savant.api.data.VariantRecord;
import savant.util.swing.RecordTableModel;

class VariantTableModel
extends RecordTableModel<VariantRecord> {
    private static final Class[] COLUMN_CLASSES = new Class[]{String.class, String.class, Integer.class, String.class, String.class};
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Type", "Position", "Ref", "Alt"};
    private final List<VariantRecord> data;

    VariantTableModel(List<VariantRecord> data) {
        this.data = data;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Class getColumnClass(int column) {
        return COLUMN_CLASSES[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.data != null) {
            VariantRecord rec = this.data.get(row);
            switch (column) {
                case 0: {
                    return rec.getName();
                }
                case 1: {
                    return rec.getVariantType().getDescription();
                }
                case 2: {
                    return rec.getPosition();
                }
                case 3: {
                    return rec.getRefBases();
                }
                case 4: {
                    return StringUtils.join((Object[])rec.getAltAlleles(), (char)',');
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.data != null ? this.data.size() : 0;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public VariantRecord getRecord(int row) {
        return this.data != null ? this.data.get(row) : null;
    }
}

