/*
 * Decompiled with CFR 0.152.
 */
package org.javadev;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import org.javadev.effects.Animation;
import org.javadev.effects.AnimationListener;

public class AnimatingCardLayout
extends CardLayout
implements AnimationListener {
    private Animation animation = null;
    protected int animationDuration = 2000;
    private Component animationPanel = null;
    private boolean isAnimating = false;
    private Component toShow = null;
    protected List comps = new ArrayList();

    public AnimatingCardLayout() {
    }

    public AnimatingCardLayout(Animation anim) {
        this.animation = anim;
    }

    public void addLayoutComponent(String name, Component comp) {
        Tuple tuple = new Tuple(name, comp);
        int idx = this.comps.indexOf(tuple);
        if (idx == -1) {
            this.comps.add(tuple);
        } else {
            Tuple existing = (Tuple)this.comps.get(idx);
            existing.comp = comp;
        }
        super.addLayoutComponent(name, comp);
    }

    public void removeLayoutComponent(Component comp) {
        int i = 0;
        while (i < this.comps.size()) {
            Tuple next = (Tuple)this.comps.get(i);
            if (next.comp == comp) {
                this.comps.remove(i);
            }
            ++i;
        }
        super.removeLayoutComponent(comp);
    }

    public void first(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.animate(parent, parent.getComponent(0), false);
        }
    }

    public void next(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int ncomponents = parent.getComponentCount();
            int nextCard = (this.getCurrent(parent) + 1) % ncomponents;
            this.animate(parent, parent.getComponent(nextCard), true);
        }
    }

    public void previous(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int ncomponents = parent.getComponentCount();
            int currentCard = this.getCurrent(parent);
            int nextCard = currentCard > 0 ? currentCard - 1 : ncomponents - 1;
            this.animate(parent, parent.getComponent(nextCard), false);
        }
    }

    public void last(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int ncomponents = parent.getComponentCount();
            this.animate(parent, parent.getComponent(ncomponents - 1), true);
        }
    }

    public void show(Container parent, String name) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int idx = this.indexOf(name);
            if (idx != -1) {
                this.animate(parent, parent.getComponent(idx), idx >= this.getCurrent(parent));
            }
        }
    }

    public void animationFinished() {
        Container parent = this.animationPanel.getParent();
        Component next = this.toShow;
        this.isAnimating = false;
        this.toShow = null;
        parent.remove(this.animationPanel);
        this.animationPanel = null;
        super.show(parent, this.nameOf(next));
    }

    private void animate(Container parent, Component toGoTo, boolean direction) {
        if (this.isAnimating) {
            throw new IllegalStateException("already animating");
        }
        Component current = this.current(parent);
        if (current == this.animationPanel) {
            return;
        }
        String nextName = this.nameOf(toGoTo);
        String curName = this.nameOf(current);
        if (this.animation == null || current == toGoTo || current == null || curName == null) {
            super.show(parent, nextName);
        } else {
            this.isAnimating = true;
            this.toShow = toGoTo;
            this.animation.setDirection(direction);
            this.animation.setAnimationDuration(this.animationDuration);
            this.animationPanel = this.animation.animate(current, this.toShow, this);
            parent.add(this.animationPanel, "__animation__");
            this.animationPanel.setVisible(true);
            current.setVisible(false);
            parent.validate();
        }
    }

    private int indexOf(String name) {
        int i = 0;
        while (i < this.comps.size()) {
            Tuple next = (Tuple)this.comps.get(i);
            if (next.name.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String nameOf(Component comp) {
        int i = 0;
        while (i < this.comps.size()) {
            Tuple next = (Tuple)this.comps.get(i);
            if (next.comp == comp) {
                return next.name;
            }
            ++i;
        }
        return null;
    }

    private Component current(Container parent) {
        int size = parent.getComponentCount();
        int i = 0;
        while (i < size) {
            Component next = parent.getComponent(i);
            if (next.isVisible()) {
                return next;
            }
            ++i;
        }
        return null;
    }

    private int getCurrent(Container parent) {
        int size = parent.getComponentCount();
        int i = 0;
        while (i < size) {
            if (parent.getComponent(i).isVisible()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public void setAnimationDuration(int animationDuration) {
        this.animationDuration = animationDuration < 500 ? 500 : animationDuration;
    }

    protected static class Tuple {
        String name;
        Component comp;

        public Tuple(String name, Component comp) {
            this.name = name;
            this.comp = comp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tuple)) {
                return false;
            }
            return this.name.equals(((Tuple)o).name);
        }
    }
}

