/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.DataReadOnlyException;
import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.column.AbstractColumn;
import java.util.Arrays;

public class LongColumn
extends AbstractColumn {
    private long[] m_values;
    private int m_size;

    public LongColumn() {
        this(0, 10, 0L);
    }

    public LongColumn(int n2) {
        this(n2, n2, 0L);
    }

    public LongColumn(int n2, int n3, long l2) {
        super(Long.TYPE, new Long(l2));
        if (n3 < n2) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new long[n3];
        Arrays.fill(this.m_values, l2);
        this.m_size = n2;
    }

    public int getRowCount() {
        return this.m_size;
    }

    public void setMaximumRow(int n2) {
        if (n2 > this.m_values.length) {
            int n3 = Math.max(3 * this.m_values.length / 2 + 1, n2);
            long[] lArray = new long[n3];
            System.arraycopy(this.m_values, 0, lArray, 0, this.m_size);
            Arrays.fill(lArray, this.m_size, n3, (Long)this.m_defaultValue);
            this.m_values = lArray;
        }
        this.m_size = n2;
    }

    public Object get(int n2) {
        return new Long(this.getLong(n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Object object, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (object == null) throw new DataTypeException("Column does not accept null values");
        if (object instanceof Number) {
            this.setLong(((Number)object).longValue(), n2);
            return;
        } else {
            if (!(object instanceof String)) throw new DataTypeException(object.getClass());
            this.setString((String)object, n2);
        }
    }

    public long getLong(int n2) throws DataTypeException {
        if (n2 < 0 || n2 > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        return this.m_values[n2];
    }

    public void setLong(long l2, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n2 < 0 || n2 >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        long l3 = this.m_values[n2];
        if (l3 == l2) {
            return;
        }
        this.m_values[n2] = l2;
        this.fireColumnEvent(n2, l3);
    }

    public int getInt(int n2) throws DataTypeException {
        return (int)this.getLong(n2);
    }

    public float getFloat(int n2) throws DataTypeException {
        return this.getLong(n2);
    }

    public double getDouble(int n2) throws DataTypeException {
        return this.getLong(n2);
    }
}

