/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.util;

import com.jidesoft.thirdparty.prefuse.data.Tuple;
import com.jidesoft.thirdparty.prefuse.data.expression.Predicate;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilterIterator
implements Iterator {
    private Predicate predicate;
    private Iterator tuples;
    private Tuple next;

    public FilterIterator(Iterator iterator, Predicate predicate) {
        this.predicate = predicate;
        this.tuples = iterator;
        this.next = this.advance();
    }

    private Tuple advance() {
        while (this.tuples.hasNext()) {
            Tuple tuple = (Tuple)this.tuples.next();
            if (!this.predicate.getBoolean(tuple)) continue;
            return tuple;
        }
        this.tuples = null;
        this.next = null;
        return null;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements");
        }
        Tuple tuple = this.next;
        this.next = this.advance();
        return tuple;
    }

    public boolean hasNext() {
        return this.tuples != null;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

