/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.cytoscape2;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.actions.GinyUtils;
import cytoscape.data.CyAttributes;
import cytoscape.data.SelectEventListener;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.CyLayouts;
import cytoscape.view.CyNetworkView;
import cytoscape.view.NetworkViewManager;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.LinearNumberToNumberInterpolator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import giny.model.Edge;
import giny.model.Node;
import giny.view.GraphView;
import java.awt.Color;
import java.awt.Frame;
import java.beans.PropertyVetoException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JInternalFrame;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.cytoscape.AbstractCytoscapeUtils;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.cytoscape2.EdgeProxyImpl;
import org.genemania.plugin.cytoscape2.NetworkProxyImpl;
import org.genemania.plugin.cytoscape2.NetworkSelectEventListener;
import org.genemania.plugin.cytoscape2.NodeProxyImpl;
import org.genemania.plugin.cytoscape2.support.Compatibility;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.proxies.EdgeProxy;
import org.genemania.plugin.proxies.NetworkProxy;
import org.genemania.plugin.proxies.NodeProxy;
import org.genemania.plugin.selection.NetworkSelectionManager;

public class CytoscapeUtilsImpl
extends AbstractCytoscapeUtils<CyNetwork, CyNode, CyEdge> {
    private final Compatibility compatibility;
    private final Map<String, Reference<CyEdge>> edges = new WeakHashMap<String, Reference<CyEdge>>();
    private ReferenceQueue<CyEdge> referenceQueue;

    public CytoscapeUtilsImpl(NetworkUtils networkUtils, Compatibility compatibility) {
        super(networkUtils);
        this.compatibility = compatibility;
        this.referenceQueue = new ReferenceQueue();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Reference reference = CytoscapeUtilsImpl.this.referenceQueue.remove();
                        CytoscapeUtilsImpl.this.edges.values().remove(reference);
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException();
                }
            }
        }).start();
    }

    static void setAttributeInternal(CyAttributes attributes, String identifier, String key, Object value) {
        if (value == null) {
            if (!attributes.hasAttribute(identifier, key)) {
                return;
            }
            attributes.deleteAttribute(identifier, key);
            return;
        }
        if (value instanceof Long) {
            attributes.setAttribute(identifier, key, Integer.valueOf(((Long)value).intValue()));
        } else if (value instanceof Integer) {
            attributes.setAttribute(identifier, key, (Integer)value);
        } else if (value instanceof String) {
            attributes.setAttribute(identifier, key, (String)value);
        } else if (value instanceof Double) {
            attributes.setAttribute(identifier, key, (Double)value);
        } else if (value instanceof Boolean) {
            attributes.setAttribute(identifier, key, (Boolean)value);
        } else if (value instanceof List) {
            attributes.setListAttribute(identifier, key, (List)value);
        }
    }

    private Calculator createEdgeWidthCalculator(CyNetwork network, double minWeight, double maxWeight, double minSize, double maxSize) {
        VisualPropertyType type = VisualPropertyType.EDGE_LINE_WIDTH;
        Object defaultObject = type.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle());
        ContinuousMapping mapping = this.compatibility.createContinuousMapping(defaultObject, "normalized max weight", network, Compatibility.MappingType.EDGE);
        mapping.setInterpolator((Interpolator)new LinearNumberToNumberInterpolator());
        mapping.addPoint(minWeight, new BoundaryRangeValues((Object)minSize, (Object)minSize, (Object)minSize));
        mapping.addPoint(maxWeight, new BoundaryRangeValues((Object)maxSize, (Object)maxSize, (Object)maxSize));
        return new BasicCalculator(String.format("edgeWidth-%s", this.escapeTitle(network.getTitle())), (ObjectMapping)mapping, type);
    }

    private Calculator createEdgeOpacityCalculator(CyNetwork network) {
        VisualPropertyType type = VisualPropertyType.EDGE_OPACITY;
        Object defaultObject = type.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle());
        DiscreteMapping mapping = this.compatibility.createDiscreteMapping(defaultObject, "highlight", network, Compatibility.MappingType.EDGE);
        mapping.putMapValue((Object)1, (Object)255);
        mapping.putMapValue((Object)0, (Object)64);
        return new BasicCalculator("Dynamic calculator", (ObjectMapping)mapping, type);
    }

    private Calculator createEdgeColourCalculator(CyNetwork network, Map<String, Color> colors) {
        VisualPropertyType type = VisualPropertyType.EDGE_COLOR;
        Object defaultObject = type.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle());
        DiscreteMapping mapping = this.compatibility.createDiscreteMapping(defaultObject, "data type", network, Compatibility.MappingType.EDGE);
        for (Map.Entry<String, Color> entry : colors.entrySet()) {
            mapping.putMapValue((Object)entry.getKey(), (Object)entry.getValue());
        }
        return new BasicCalculator(String.format("edgeColour-%s", this.escapeTitle(network.getTitle())), (ObjectMapping)mapping, type);
    }

    private String escapeTitle(String title) {
        return title.replaceAll("[.]", "_");
    }

    private Calculator createNodeColourCalculator(CyNetwork network) {
        VisualPropertyType type = VisualPropertyType.NODE_FILL_COLOR;
        Object defaultObject = type.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle());
        DiscreteMapping mapping = this.compatibility.createDiscreteMapping(defaultObject, "node type", network, Compatibility.MappingType.NODE);
        mapping.putMapValue((Object)"query", (Object)QUERY_COLOR);
        mapping.putMapValue((Object)"result", (Object)RESULT_COLOR);
        mapping.putMapValue((Object)"attribute", (Object)RESULT_COLOR);
        return new BasicCalculator("Type-based calculator", (ObjectMapping)mapping, type);
    }

    private Calculator createNodeSizeCalculator(CyNetwork network, Map<Long, Double> scores, double minSize, double maxSize) {
        VisualPropertyType type = VisualPropertyType.NODE_SIZE;
        Object defaultObject = type.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle());
        ContinuousMapping mapping = this.compatibility.createContinuousMapping(defaultObject, "score", network, Compatibility.MappingType.NODE);
        double[] values = this.networkUtils.sortScores(scores);
        mapping.setInterpolator((Interpolator)new LinearNumberToNumberInterpolator());
        mapping.addPoint(values[0], new BoundaryRangeValues((Object)minSize, (Object)minSize, (Object)minSize));
        mapping.addPoint(values[values.length - 1], new BoundaryRangeValues((Object)maxSize, (Object)maxSize, (Object)maxSize));
        return new BasicCalculator(String.format("nodeSize-%s", this.escapeTitle(network.getTitle())), (ObjectMapping)mapping, type);
    }

    public void applyVisualization(CyNetwork network, Map<Long, Double> scores, Map<String, Color> colors, double[] extrema) {
        String styleName;
        VisualMappingManager manager = Cytoscape.getVisualMappingManager();
        CalculatorCatalog catalog = manager.getCalculatorCatalog();
        VisualStyle style = catalog.getVisualStyle(styleName = this.getVisualStyleName(network));
        if (style == null) {
            style = new VisualStyle(styleName);
        }
        NodeAppearanceCalculator nodeAppearance = style.getNodeAppearanceCalculator();
        nodeAppearance.setCalculator(this.createNodeColourCalculator(network));
        nodeAppearance.setCalculator(this.createNodeLabelCalculator());
        nodeAppearance.setCalculator(this.createNodeShapeCalculator(network));
        nodeAppearance.setCalculator(this.createNodeSizeCalculator(network, scores, 10.0, 40.0));
        EdgeAppearanceCalculator edgeAppearance = style.getEdgeAppearanceCalculator();
        edgeAppearance.setCalculator(this.createEdgeColourCalculator(network, colors));
        edgeAppearance.setCalculator(this.createEdgeOpacityCalculator(network));
        edgeAppearance.setCalculator(this.createEdgeWidthCalculator(network, extrema[0], extrema[1], 1.0, 6.0));
        VisualPropertyType.NODE_LABEL_POSITION.setDefault(style, this.compatibility.createDefaultNodeLabelPosition());
        VisualPropertyType.NODE_SHAPE.setDefault(style, (Object)NodeShape.ELLIPSE);
        catalog.removeVisualStyle(styleName);
        catalog.addVisualStyle(style);
        manager.setVisualStyle(style);
        CyNetworkView networkView = this.getNetworkView(network);
        networkView.setVisualStyle(styleName);
        manager.applyNodeAppearances(network, networkView);
    }

    private Calculator createNodeShapeCalculator(CyNetwork network) {
        VisualPropertyType type = VisualPropertyType.NODE_SHAPE;
        Object defaultObject = type.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle());
        DiscreteMapping mapping = this.compatibility.createDiscreteMapping(defaultObject, "node type", network, Compatibility.MappingType.NODE);
        mapping.putMapValue((Object)"attribute", (Object)NodeShape.DIAMOND);
        return new BasicCalculator("Gene name calculator", (ObjectMapping)mapping, type);
    }

    private CyNetworkView getNetworkView(CyNetwork network) {
        String id = network.getIdentifier();
        if (!Cytoscape.viewExists((String)id)) {
            return Cytoscape.createNetworkView((CyNetwork)network);
        }
        return Cytoscape.getNetworkView((String)id);
    }

    public void performLayout(CyNetwork network) {
        CyNetworkView view = this.getNetworkView(network);
        CyLayoutAlgorithm layout = CyLayouts.getLayout((String)"genemania-filtered-layout");
        if (layout == null) {
            layout = CyLayouts.getDefaultLayout();
        }
        layout.doLayout(view);
    }

    private Calculator createNodeLabelCalculator() {
        VisualPropertyType type = VisualPropertyType.NODE_LABEL;
        Object defaultObject = type.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle());
        PassThroughMapping mapping = this.compatibility.createPassThroughMapping(defaultObject, "gene name");
        return new BasicCalculator("Gene name calculator", (ObjectMapping)mapping, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setVisibility(GeneMania<CyNetwork, CyNode, CyEdge> plugin, ViewState config, Group<?, ?> source, CyNetwork network, boolean selected) {
        NetworkSelectionManager manager = plugin.getNetworkSelectionManager();
        boolean listenerEnabled = manager.isSelectionListenerEnabled();
        manager.setSelectionListenerEnabled(false);
        CyNetworkView view = this.getNetworkView(network);
        if (!selected && source == null) {
            GinyUtils.hideAllEdges((GraphView)view);
            return;
        }
        if (selected && source == null) {
            GinyUtils.unHideAllEdges((GraphView)view);
            return;
        }
        try {
            config.setEnabled(source, selected);
            if (selected) {
                for (Object edgeId : config.getEdgeIds(source)) {
                    CyEdge edge = Cytoscape.getRootGraph().getEdge((String)edgeId);
                    view.showGraphObject((Object)view.getEdgeView((Edge)edge));
                }
            } else {
                for (Object edgeId : config.getEdgeIds(source)) {
                    CyEdge edge = Cytoscape.getRootGraph().getEdge((String)edgeId);
                    view.hideGraphObject((Object)view.getEdgeView((Edge)edge));
                }
            }
        }
        finally {
            manager.setSelectionListenerEnabled(listenerEnabled);
        }
        view.updateView();
        Cytoscape.getVisualMappingManager().applyEdgeAppearances(network, view);
    }

    public void registerSelectionListener(CyNetwork network, NetworkSelectionManager<CyNetwork, CyNode, CyEdge> manager, GeneMania<CyNetwork, CyNode, CyEdge> plugin) {
        NetworkSelectEventListener listener = new NetworkSelectEventListener(network, manager, plugin, (CytoscapeUtils<CyNetwork, CyNode, CyEdge>)this);
        network.addSelectEventListener((SelectEventListener)listener);
    }

    public CyNetwork getCurrentNetwork() {
        return Cytoscape.getCurrentNetwork();
    }

    public void repaint() {
        Cytoscape.getDesktop().repaint();
    }

    public void updateVisualStyles(CyNetwork network) {
        VisualMappingManager manager = Cytoscape.getVisualMappingManager();
        CyNetworkView networkView = this.getNetworkView(network);
        manager.applyEdgeAppearances(network, networkView);
    }

    public void maximize(CyNetwork network) {
        NetworkViewManager viewManager = Cytoscape.getDesktop().getNetworkViewManager();
        CyNetworkView view = this.getNetworkView(network);
        JInternalFrame frame = viewManager.getInternalFrame(view);
        try {
            frame.setMaximum(true);
        }
        catch (PropertyVetoException e) {
            LogUtils.log(((Object)((Object)this)).getClass(), (Throwable)e);
        }
    }

    public Frame getFrame() {
        return Cytoscape.getDesktop();
    }

    public Set<CyNetwork> getNetworks() {
        return Cytoscape.getNetworkSet();
    }

    public void handleNetworkPostProcessing(CyNetwork network) {
        Cytoscape.firePropertyChange((String)"NETWORK_MODIFIED", null, null);
        Cytoscape.firePropertyChange((String)Cytoscape.ATTRIBUTES_CHANGED, null, null);
    }

    static <T> T getAttributeInternal(CyAttributes attributes, String id, String name, Class<T> type) {
        if (type.equals(String.class)) {
            return (T)attributes.getStringAttribute(id, name);
        }
        if (type.equals(Long.class)) {
            return (T)attributes.getIntegerAttribute(id, name);
        }
        if (type.equals(Integer.class)) {
            return (T)attributes.getIntegerAttribute(id, name);
        }
        if (type.equals(Double.class)) {
            return (T)attributes.getDoubleAttribute(id, name);
        }
        if (type.equals(Boolean.class)) {
            return (T)attributes.getBooleanAttribute(id, name);
        }
        if (type.equals(List.class)) {
            return (T)attributes.getListAttribute(id, name);
        }
        return (T)attributes.getAttribute(id, name);
    }

    protected NetworkProxy<CyNetwork, CyNode, CyEdge> createNetworkProxy(CyNetwork network) {
        return new NetworkProxyImpl(network);
    }

    protected NodeProxy<CyNode> createNodeProxy(CyNode node, CyNetwork network) {
        return new NodeProxyImpl(node);
    }

    protected EdgeProxy<CyEdge, CyNode> createEdgeProxy(CyEdge edge, CyNetwork network) {
        return new EdgeProxyImpl(edge);
    }

    public Properties getGlobalProperties() {
        return CytoscapeInit.getProperties();
    }

    protected CyNode getNode(String id, CyNetwork network) {
        return Cytoscape.getCyNode((String)id);
    }

    protected CyNode createNode(String id, CyNetwork network) {
        CyNode node = Cytoscape.getCyNode((String)id, (boolean)true);
        network.addNode((Node)node);
        return node;
    }

    protected CyNetwork createNetwork(String title) {
        return Cytoscape.createNetwork((String)title, (boolean)false);
    }

    protected CyEdge getEdge(String id, CyNetwork network) {
        Reference<CyEdge> reference = this.edges.get(id);
        if (reference == null) {
            this.cacheNetwork(network);
            reference = this.edges.get(id);
            if (reference == null) {
                return null;
            }
        }
        return reference.get();
    }

    private void cacheNetwork(CyNetwork network) {
        Iterator iterator = network.edgesIterator();
        while (iterator.hasNext()) {
            CyEdge edge = (CyEdge)iterator.next();
            this.edges.put(edge.getIdentifier(), new WeakReference<CyEdge>(edge, this.referenceQueue));
        }
    }

    protected CyEdge getEdge(CyNode from, CyNode to, String type, String label, CyNetwork network) {
        CyEdge edge = Cytoscape.getCyEdge((Node)from, (Node)to, (String)"interaction", (Object)label, (boolean)true);
        network.addEdge((Edge)edge);
        this.edges.put(edge.getIdentifier(), new WeakReference<CyEdge>(edge, this.referenceQueue));
        return edge;
    }
}

