/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.cytoscape2;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.CyLayouts;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.NetworkViewManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.SwingPropertyChangeSupport;
import org.genemania.plugin.AbstractGeneMania;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.cytoscape2.SessionChangeListener;
import org.genemania.plugin.cytoscape2.actions.AboutAction;
import org.genemania.plugin.cytoscape2.actions.ManiaResultsAction;
import org.genemania.plugin.cytoscape2.actions.RetrieveRelatedGenesAction;
import org.genemania.plugin.cytoscape2.layout.FilteredLayout;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetChangeListener;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.view.ManiaResultsPanel;
import org.genemania.plugin.view.RetrieveRelatedGenesDialog;
import org.genemania.plugin.view.util.UiUtils;
import org.genemania.util.ProgressReporter;

public class GeneManiaImpl
extends AbstractGeneMania<CyNetwork, CyNode, CyEdge>
implements GeneMania<CyNetwork, CyNode, CyEdge> {
    protected RetrieveRelatedGenesAction<CyNetwork, CyNode, CyEdge> retrieveRelatedGenesAction;
    protected ManiaResultsAction<CyNetwork, CyNode, CyEdge> showResultsAction;
    protected PropertyChangeListener networkFocusListener;
    protected PropertyChangeListener networkDestroyedListener;
    protected SessionChangeListener sessionChangeListener;

    public GeneManiaImpl(DataSetManager dataSetManager, final CytoscapeUtils<CyNetwork, CyNode, CyEdge> cytoscapeUtils, UiUtils uiUtils, FileUtils fileUtils, NetworkUtils networkUtils, TaskDispatcher taskDispatcher) {
        super(dataSetManager, cytoscapeUtils, uiUtils, fileUtils, networkUtils, taskDispatcher);
        dataSetManager.addDataSetChangeListener(new DataSetChangeListener(){

            public void dataSetChanged(DataSet dataSet, ProgressReporter progress) {
                Properties properties = cytoscapeUtils.getGlobalProperties();
                if (dataSet == null) {
                    properties.remove("genemania.datasource");
                    return;
                }
                properties.setProperty("genemania.datasource", dataSet.getBasePath());
            }
        });
    }

    public void startUp() {
        this.sessionChangeListener = new SessionChangeListener(this, this.taskDispatcher, (CytoscapeUtils<CyNetwork, CyNode, CyEdge>)this.cytoscapeUtils);
        PropertyChangeSupport coreSupport = Cytoscape.getPropertyChangeSupport();
        coreSupport.addPropertyChangeListener(Cytoscape.SESSION_LOADED, this.sessionChangeListener);
        this.networkFocusListener = this.selectionManager.getNetworkChangeListener();
        this.networkDestroyedListener = this.selectionManager.getNetworkDestroyedListener();
        NetworkViewManager viewManager = Cytoscape.getDesktop().getNetworkViewManager();
        SwingPropertyChangeSupport support = viewManager.getSwingPropertyChangeSupport();
        support.addPropertyChangeListener("NETWORK_VIEW_FOCUSED", this.networkFocusListener);
        coreSupport.addPropertyChangeListener(Cytoscape.NETWORK_DESTROYED, this.networkDestroyedListener);
        this.retrieveRelatedGenesAction = new RetrieveRelatedGenesAction<CyNetwork, CyNode, CyEdge>(Strings.retrieveRelatedGenes_menuLabel, this, this.cytoscapeUtils, this.networkUtils, this.uiUtils, this.fileUtils, this.taskDispatcher);
        this.showResultsAction = new ManiaResultsAction<CyNetwork, CyNode, CyEdge>(Strings.maniaResults_menuLabel, this, this.cytoscapeUtils, this.networkUtils, this.uiUtils);
        AboutAction aboutAction = new AboutAction(Strings.about_menuLabel, this.uiUtils, this.cytoscapeUtils);
        CytoscapeAction checkAction = new CytoscapeAction(Strings.dataUpdateCheck_menuLabel){

            public void actionPerformed(ActionEvent event) {
                GeneManiaImpl.this.handleCheck();
            }
        };
        CytoscapeAction downloadAction = new CytoscapeAction(Strings.dataUpdateDownload_menuLabel){

            public void actionPerformed(ActionEvent event) {
                GeneManiaImpl.this.handleDownload();
            }
        };
        CytoscapeAction switchAction = new CytoscapeAction(Strings.changeData_menuLabel){

            public void actionPerformed(ActionEvent event) {
                GeneManiaImpl.this.handleSwitch();
            }
        };
        this.showResultsMenu = new JMenuItem((Action)((Object)this.showResultsAction));
        this.showResultsAction.setMenuItem(this.showResultsMenu);
        JMenu menu = new JMenu(Strings.root_menuLabel);
        menu.add(new JMenuItem((Action)((Object)this.retrieveRelatedGenesAction)));
        menu.add(this.showResultsMenu);
        menu.add(new JMenuItem((Action)downloadAction));
        menu.add(new JMenuItem((Action)switchAction));
        menu.add(new JSeparator());
        menu.add(new JMenuItem((Action)((Object)aboutAction)));
        menu.add(new JMenuItem((Action)checkAction));
        this.rootMenuItem = Cytoscape.getDesktop().getCyMenus().getOperationsMenu().add(menu);
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                GeneManiaImpl.this.validateMenu();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        CyLayouts.addLayout((CyLayoutAlgorithm)new FilteredLayout(this), (String)Strings.layoutMenu_title);
    }

    public void shutDown() {
        PropertyChangeSupport coreSupport = Cytoscape.getPropertyChangeSupport();
        coreSupport.removePropertyChangeListener(this.sessionChangeListener);
        NetworkViewManager viewManager = Cytoscape.getDesktop().getNetworkViewManager();
        SwingPropertyChangeSupport support = viewManager.getSwingPropertyChangeSupport();
        support.removePropertyChangeListener(this.networkFocusListener);
        support.removePropertyChangeListener(this.networkDestroyedListener);
        Cytoscape.getDesktop().getCyMenus().getViewMenu().remove(this.rootMenuItem);
        this.rootMenuItem = null;
    }

    public RetrieveRelatedGenesDialog<CyNetwork, CyNode, CyEdge> getResultsDialog() {
        return this.retrieveRelatedGenesAction.getDialog();
    }

    public void showResults() {
        this.showResultsAction.actionPerformed(new ActionEvent((Object)this, 0, "show"));
    }

    public void hideResults() {
        this.showResultsAction.actionPerformed(new ActionEvent((Object)this, 0, "hide"));
    }

    public void showQuery() {
        this.retrieveRelatedGenesAction.actionPerformed(null);
    }

    public void applyOptions(ViewState options) {
        ManiaResultsPanel panel = (ManiaResultsPanel)this.showResultsAction.getPanel();
        panel.applyOptions(options);
    }

    public void updateSelection(ViewState options) {
        ManiaResultsPanel panel = (ManiaResultsPanel)this.showResultsAction.getPanel();
        panel.updateSelection(options);
    }
}

