/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.cytoscape2;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.SelectFilter;
import giny.model.Edge;
import giny.model.Node;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.genemania.plugin.OneUseIterable;
import org.genemania.plugin.cytoscape2.ProxyImpl;
import org.genemania.plugin.proxies.NetworkProxy;

class NetworkProxyImpl
extends ProxyImpl<CyNetwork>
implements NetworkProxy<CyNetwork, CyNode, CyEdge> {
    NetworkProxyImpl(CyNetwork network) {
        super(network);
    }

    @Override
    protected CyAttributes getAttributes() {
        return Cytoscape.getNetworkAttributes();
    }

    public Collection<CyEdge> getEdges() {
        HashSet<CyEdge> edges = new HashSet<CyEdge>();
        for (CyEdge edge : new OneUseIterable(((CyNetwork)this.getProxied()).edgesIterator())) {
            edges.add(edge);
        }
        return edges;
    }

    public Collection<CyNode> getNodes() {
        HashSet<CyNode> nodes = new HashSet<CyNode>();
        for (CyNode node : new OneUseIterable(((CyNetwork)this.getProxied()).nodesIterator())) {
            nodes.add(node);
        }
        return nodes;
    }

    public Set<CyEdge> getSelectedEdges() {
        HashSet<CyEdge> edges = new HashSet<CyEdge>();
        for (CyEdge edge : ((CyNetwork)this.getProxied()).getSelectedEdges()) {
            edges.add(edge);
        }
        return edges;
    }

    public Set<CyNode> getSelectedNodes() {
        HashSet<CyNode> nodes = new HashSet<CyNode>();
        for (CyNode node : ((CyNetwork)this.getProxied()).getSelectedNodes()) {
            nodes.add(node);
        }
        return nodes;
    }

    public String getTitle() {
        return ((CyNetwork)this.getProxied()).getTitle();
    }

    public void setSelectedNode(CyNode node, boolean selected) {
        SelectFilter filter = ((CyNetwork)this.getProxied()).getSelectFilter();
        filter.setSelected((Node)node, selected);
    }

    public void setSelectedEdge(CyEdge edge, boolean selected) {
        SelectFilter filter = ((CyNetwork)this.getProxied()).getSelectFilter();
        filter.setSelected((Edge)edge, selected);
    }

    public void setSelectedEdges(Collection<CyEdge> proxies, boolean selected) {
        SelectFilter filter = ((CyNetwork)this.getProxied()).getSelectFilter();
        HashSet<CyEdge> edges = new HashSet<CyEdge>();
        for (CyEdge proxy : proxies) {
            edges.add(proxy);
        }
        filter.setSelectedEdges(edges, selected);
    }

    public void setSelectedNodes(Collection<CyNode> proxies, boolean selected) {
        SelectFilter filter = ((CyNetwork)this.getProxied()).getSelectFilter();
        HashSet<CyNode> nodes = new HashSet<CyNode>();
        for (CyNode proxy : proxies) {
            nodes.add(proxy);
        }
        filter.setSelectedNodes(nodes, selected);
    }

    public void unselectAllEdges() {
        ((CyNetwork)this.getProxied()).getSelectFilter().unselectAllEdges();
    }

    public void unselectAllNodes() {
        ((CyNetwork)this.getProxied()).getSelectFilter().unselectAllNodes();
    }

    public String getIdentifier() {
        return ((CyNetwork)this.getProxied()).getIdentifier();
    }

    public Collection<String> getNodeAttributeNames() {
        return Arrays.asList(Cytoscape.getNodeAttributes().getAttributeNames());
    }

    public Collection<String> getEdgeAttributeNames() {
        return Arrays.asList(Cytoscape.getEdgeAttributes().getAttributeNames());
    }

    public Collection<CyNode> getNeighbours(CyNode node) {
        HashSet<CyNode> neighbours = new HashSet<CyNode>();
        CyNetwork network = (CyNetwork)this.getProxied();
        int nodeIndex = node.getRootGraphIndex();
        for (int index : network.getAdjacentEdgeIndicesArray(nodeIndex, true, true, true)) {
            CyEdge edge = (CyEdge)network.getEdge(index);
            CyNode other = (CyNode)edge.getSource();
            if (other.getRootGraphIndex() == nodeIndex && (other = (CyNode)edge.getTarget()).getRootGraphIndex() == nodeIndex) continue;
            neighbours.add(other);
        }
        return neighbours;
    }
}

