/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.cytoscape2;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.data.SelectEvent;
import cytoscape.data.SelectEventListener;
import java.util.Set;
import org.genemania.exception.ApplicationException;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.delegates.NodeSelectionDelegate;
import org.genemania.plugin.delegates.NodeSetSelectionDelegate;
import org.genemania.plugin.delegates.SelectionDelegate;
import org.genemania.plugin.selection.NetworkSelectionManager;

public class NetworkSelectEventListener
implements SelectEventListener {
    private final CyNetwork network;
    private final NetworkSelectionManager<CyNetwork, CyNode, CyEdge> manager;
    private final GeneMania<CyNetwork, CyNode, CyEdge> plugin;
    private final CytoscapeUtils<CyNetwork, CyNode, CyEdge> cytoscapeUtils;
    private final SelectionDelegate<CyNetwork, CyNode, CyEdge> defaultDelegate;

    public NetworkSelectEventListener(CyNetwork network, NetworkSelectionManager<CyNetwork, CyNode, CyEdge> manager, GeneMania<CyNetwork, CyNode, CyEdge> plugin, CytoscapeUtils<CyNetwork, CyNode, CyEdge> cytoscapeUtils) {
        this.network = network;
        this.manager = manager;
        this.plugin = plugin;
        this.cytoscapeUtils = cytoscapeUtils;
        this.defaultDelegate = new SelectionDelegate(true, (Object)network, manager, plugin, cytoscapeUtils);
    }

    public void onSelectEvent(SelectEvent event) {
        NodeSetSelectionDelegate delegate;
        boolean selected = event.getEventType();
        switch (event.getTargetType()) {
            case 1: 
            case 3: {
                delegate = this.defaultDelegate;
                break;
            }
            case 2: {
                delegate = new NodeSetSelectionDelegate((Set)event.getTarget(), selected, (Object)this.network, this.manager, this.plugin, this.cytoscapeUtils);
                break;
            }
            case 0: {
                delegate = new NodeSelectionDelegate((Object)((CyNode)event.getTarget()), selected, (Object)this.network, this.manager, this.plugin, this.cytoscapeUtils);
                break;
            }
            default: {
                return;
            }
        }
        try {
            delegate.invoke();
        }
        catch (ApplicationException e) {
            LogUtils.log(this.getClass(), (Throwable)e);
        }
    }
}

