/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.cytoscape2;

import cytoscape.data.CyAttributes;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import org.genemania.plugin.cytoscape2.CytoscapeUtilsImpl;
import org.genemania.plugin.proxies.Proxy;

abstract class ProxyImpl<T>
implements Proxy<T> {
    private final Reference<T> reference;

    ProxyImpl(T proxied) {
        this.reference = new WeakReference<T>(proxied);
    }

    protected abstract CyAttributes getAttributes();

    public <U> U getAttribute(String name, Class<U> type) {
        return CytoscapeUtilsImpl.getAttributeInternal(this.getAttributes(), this.getIdentifier(), name, type);
    }

    public T getProxied() {
        return this.reference.get();
    }

    public <U> void setAttribute(String name, U value) {
        CytoscapeUtilsImpl.setAttributeInternal(this.getAttributes(), this.getIdentifier(), name, value);
    }

    public Class<?> getAttributeType(String name) {
        switch (this.getAttributes().getType(name)) {
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return Double.class;
            }
            case 3: {
                return Integer.class;
            }
            case -2: {
                return List.class;
            }
            case 4: {
                return String.class;
            }
        }
        return null;
    }
}

