/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.cytoscape2;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Properties;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.Strings;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.delegates.SessionChangeDelegate;
import org.genemania.plugin.selection.NetworkSelectionManager;
import org.genemania.plugin.task.GeneManiaTask;
import org.genemania.plugin.task.TaskDispatcher;

public class SessionChangeListener
implements PropertyChangeListener {
    private final CytoscapeUtils<CyNetwork, CyNode, CyEdge> cytoscapeUtils;
    private final GeneMania<CyNetwork, CyNode, CyEdge> plugin;
    private final TaskDispatcher taskDispatcher;

    public SessionChangeListener(GeneMania<CyNetwork, CyNode, CyEdge> plugin, TaskDispatcher taskDispatcher, CytoscapeUtils<CyNetwork, CyNode, CyEdge> cytoscapeUtils) {
        this.plugin = plugin;
        this.taskDispatcher = taskDispatcher;
        this.cytoscapeUtils = cytoscapeUtils;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Properties properties = CytoscapeInit.getProperties();
        String dataSourcePath = properties.getProperty("genemania.datasource");
        final File path = dataSourcePath == null ? null : new File(dataSourcePath);
        GeneManiaTask task = new GeneManiaTask(Strings.sessionChangeListener_title){

            protected void runTask() throws Throwable {
                SessionChangeDelegate delegate = new SessionChangeDelegate(path, SessionChangeListener.this.plugin, this.progress, SessionChangeListener.this.cytoscapeUtils);
                delegate.invoke();
                CyNetwork currentNetwork = (CyNetwork)SessionChangeListener.this.cytoscapeUtils.getCurrentNetwork();
                PropertyChangeEvent event = new PropertyChangeEvent(Cytoscape.getDesktop(), "NETWORK_VIEW_FOCUSED", null, currentNetwork.getIdentifier());
                NetworkSelectionManager manager = SessionChangeListener.this.plugin.getNetworkSelectionManager();
                manager.getNetworkChangeListener().propertyChange(event);
            }
        };
        this.taskDispatcher.executeTask(task, (Window)this.cytoscapeUtils.getFrame(), true, true);
    }
}

