/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.cytoscape2.layout;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.SelectFilter;
import cytoscape.layout.AbstractLayout;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.CyLayouts;
import cytoscape.layout.LayoutProperties;
import cytoscape.layout.Tunable;
import cytoscape.task.TaskMonitor;
import cytoscape.view.CyNetworkView;
import giny.model.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.OneUseIterable;
import org.genemania.plugin.Strings;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetChangeListener;
import org.genemania.plugin.selection.NetworkSelectionManager;
import org.genemania.util.ProgressReporter;

public class FilteredLayout
extends AbstractLayout {
    private static final String GROUP_ATTRIBUTE = "groups";
    public static final String ID = "genemania-filtered-layout";
    private static final String FORCE_DIRECTED_LAYOUT_ID = "force-directed";
    private final LayoutProperties properties;
    private final GeneMania<CyNetwork, CyNode, CyEdge> plugin;

    public FilteredLayout(GeneMania<CyNetwork, CyNode, CyEdge> plugin) {
        this.plugin = plugin;
        this.properties = new LayoutProperties(this.getName());
        this.createGroupList();
        String initialValue = "";
        Object[] groupList = new Object[]{};
        this.properties.add(new Tunable(GROUP_ATTRIBUTE, Strings.filteredLayout_groupsTunable, 6, (Object)initialValue, (Object)groupList, null, 4));
        this.properties.initializeProperties();
        this.updateSettings(true);
    }

    public LayoutProperties getSettings() {
        return this.properties;
    }

    private void createGroupList() {
        this.plugin.getDataSetManager().addDataSetChangeListener(new DataSetChangeListener(){

            public void dataSetChanged(DataSet data, ProgressReporter progress) {
                FilteredLayout.this.populateGroups(data);
            }
        });
        DataSet data = this.plugin.getDataSetManager().getDataSet();
        if (data == null) {
            return;
        }
        this.populateGroups(data);
    }

    protected void populateGroups(DataSet data) {
        Tunable tunable = this.properties.get(GROUP_ATTRIBUTE);
        HashSet<String> names = new HashSet<String>();
        try {
            if (data != null) {
                for (Organism organism : data.getMediatorProvider().getOrganismMediator().getAllOrganisms()) {
                    for (InteractionNetworkGroup group : organism.getInteractionNetworkGroups()) {
                        names.add(group.getName());
                    }
                }
            }
        }
        catch (DataStoreException e) {
            LogUtils.log(((Object)((Object)this)).getClass(), (Throwable)e);
        }
        ArrayList<String> groups = new ArrayList<String>();
        groups.addAll(names);
        Collections.sort(groups, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        tunable.setLowerBound((Object)groups.toArray());
        StringBuilder indices = new StringBuilder();
        int index = 0;
        for (String group : groups) {
            if (group.equalsIgnoreCase("Co-expression") || group.equalsIgnoreCase("Co-localization")) {
                if (indices.length() > 0) {
                    indices.append(",");
                }
                indices.append(index);
            }
            ++index;
        }
        tunable.setValue((Object)indices.toString());
    }

    private void updateSettings(boolean force) {
        this.properties.updateValues();
    }

    private List<String> decodeGroups(Tunable tunable) {
        ArrayList<String> groups = new ArrayList<String>();
        Object[] items = (Object[])tunable.getLowerBound();
        String value = (String)tunable.getValue();
        for (String rawIndex : value.split(",")) {
            try {
                int index = Integer.parseInt(rawIndex);
                String group = (String)items[index];
                groups.add(group);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return groups;
    }

    public void revertSettings() {
        this.properties.revertProperties();
    }

    public JPanel getSettingsPanel() {
        return this.properties.getTunablePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLayout(CyNetworkView view, TaskMonitor monitor) {
        CyLayoutAlgorithm layout = CyLayouts.getLayout((String)FORCE_DIRECTED_LAYOUT_ID);
        if (layout == null) {
            return;
        }
        if (!layout.supportsSelectedOnly()) {
            return;
        }
        if (!(layout instanceof AbstractLayout)) {
            return;
        }
        AbstractLayout layout2 = (AbstractLayout)layout;
        layout2.setSelectedOnly(true);
        LayoutProperties settings = layout2.getSettings();
        double defaultMass = -2.2222222222222223 * (double)view.getNetwork().getNodeCount() + 1000.0;
        settings.get("selected_only").setValue((Object)true);
        settings.get("edge_attribute").setValue((Object)"normalized max weight");
        settings.get("weight_type").setValue((Object)1);
        settings.get("min_weight").setValue((Object)0.0);
        settings.get("max_weight").setValue((Object)10.0);
        settings.get("defaultSpringCoefficient").setValue((Object)0.1);
        settings.get("defaultSpringLength").setValue((Object)1.0);
        settings.get("defaultNodeMass").setValue((Object)defaultMass);
        settings.get("numIterations").setValue((Object)100);
        layout2.updateSettings();
        NetworkSelectionManager manager = this.plugin.getNetworkSelectionManager();
        manager.setSelectionListenerEnabled(false);
        CyNetwork network = Cytoscape.getCurrentNetwork();
        SelectFilter filter = network.getSelectFilter();
        try {
            filter.unselectAllNodes();
            filter.unselectAllEdges();
            this.applySelection(network);
            layout2.doLayout(view, monitor);
            view.fitContent();
            Cytoscape.getDesktop().repaint();
        }
        finally {
            filter.unselectAllNodes();
            filter.unselectAllEdges();
            manager.setSelectionListenerEnabled(true);
        }
    }

    public void construct() {
    }

    private void applySelection(CyNetwork network) {
        SelectFilter filter = network.getSelectFilter();
        try {
            Set<String> excludedGroups = this.computeExcludedGroups(this.properties.get(GROUP_ATTRIBUTE));
            HashSet<Node> nodes = new HashSet<Node>();
            HashSet<CyEdge> edges = new HashSet<CyEdge>();
            CyAttributes attributes = Cytoscape.getEdgeAttributes();
            for (CyEdge edge : new OneUseIterable(network.edgesIterator())) {
                String groupName = attributes.getStringAttribute(edge.getIdentifier(), "data type");
                if (excludedGroups.contains(groupName)) continue;
                edges.add(edge);
                nodes.add(edge.getSource());
                nodes.add(edge.getTarget());
            }
            if (edges.isEmpty()) {
                filter.selectAllEdges();
                filter.selectAllNodes();
            } else {
                filter.setSelectedNodes(nodes, true);
                filter.setSelectedEdges(edges, true);
            }
        }
        catch (DataStoreException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<String> computeExcludedGroups(Tunable tunable) throws DataStoreException {
        List<String> exclusions = this.decodeGroups(tunable);
        return new HashSet<String>(exclusions);
    }

    public String getName() {
        return ID;
    }

    public String toString() {
        return Strings.filteredLayout_title;
    }
}

