/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.surfaceplotter;

import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import net.ericaro.surfaceplotter.Mapper;
import net.ericaro.surfaceplotter.surface.AbstractSurfaceModel;
import net.ericaro.surfaceplotter.surface.SurfaceModel;
import net.ericaro.surfaceplotter.surface.SurfaceVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSurfaceModel
extends AbstractSurfaceModel
implements SurfaceModel {
    private Mapper mapper;
    protected SurfaceVertex[][] surfaceVertex;

    public SwingWorker<Void, Void> plot() {
        if (this.xMin >= this.xMax || this.yMin >= this.yMax) {
            throw new NumberFormatException();
        }
        this.setDataAvailable(false);
        final float stepx = (this.xMax - this.xMin) / (float)this.calcDivisions;
        final float stepy = (this.yMax - this.yMin) / (float)this.calcDivisions;
        final float xfactor = 20.0f / (this.xMax - this.xMin);
        final float yfactor = 20.0f / (this.yMax - this.yMin);
        final int total = (this.calcDivisions + 1) * (this.calcDivisions + 1);
        this.surfaceVertex = this.allocateMemory(this.hasFunction1, this.hasFunction2, total);
        for (int i = 0; i <= this.calcDivisions; ++i) {
            for (int j = 0; j <= this.calcDivisions; ++j) {
                int k = i * (this.calcDivisions + 1) + j;
                float x = this.xMin + (float)i * stepx;
                float y = this.yMin + (float)j * stepy;
                if (this.hasFunction1) {
                    this.surfaceVertex[0][k] = new SurfaceVertex((x - this.xMin) * xfactor - 10.0f, (y - this.yMin) * yfactor - 10.0f, Float.NaN);
                }
                if (!this.hasFunction2) continue;
                this.surfaceVertex[1][k] = new SurfaceVertex((x - this.xMin) * xfactor - 10.0f, (y - this.yMin) * yfactor - 10.0f, Float.NaN);
            }
        }
        this.setSurfaceVertex(this.surfaceVertex);
        this.setDataAvailable(true);
        this.getProjector();
        return new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                this.setProgress(0);
                this.setProgress(1);
                for (int i = 0; i <= DefaultSurfaceModel.this.calcDivisions; ++i) {
                    for (int j = 0; j <= DefaultSurfaceModel.this.calcDivisions; ++j) {
                        int k = i * (DefaultSurfaceModel.this.calcDivisions + 1) + j;
                        float x = DefaultSurfaceModel.this.xMin + (float)i * stepx;
                        float y = DefaultSurfaceModel.this.yMin + (float)j * stepy;
                        if (DefaultSurfaceModel.this.hasFunction1) {
                            float v1 = DefaultSurfaceModel.this.mapper.f1(x, y);
                            if (Float.isInfinite(v1)) {
                                v1 = Float.NaN;
                            }
                            if (!Float.isNaN(v1)) {
                                if (Float.isNaN(DefaultSurfaceModel.this.z1Max) || v1 > DefaultSurfaceModel.this.z1Max) {
                                    DefaultSurfaceModel.this.z1Max = v1;
                                } else if (Float.isNaN(DefaultSurfaceModel.this.z1Min) || v1 < DefaultSurfaceModel.this.z1Min) {
                                    DefaultSurfaceModel.this.z1Min = v1;
                                }
                            }
                            DefaultSurfaceModel.this.surfaceVertex[0][k] = new SurfaceVertex((x - DefaultSurfaceModel.this.xMin) * xfactor - 10.0f, (y - DefaultSurfaceModel.this.yMin) * yfactor - 10.0f, v1);
                        }
                        if (DefaultSurfaceModel.this.hasFunction2) {
                            float v2 = DefaultSurfaceModel.this.mapper.f2(x, y);
                            if (Float.isInfinite(v2)) {
                                v2 = Float.NaN;
                            }
                            if (!Float.isNaN(v2)) {
                                if (Float.isNaN(DefaultSurfaceModel.this.z2Max) || v2 > DefaultSurfaceModel.this.z2Max) {
                                    DefaultSurfaceModel.this.z2Max = v2;
                                } else if (Float.isNaN(DefaultSurfaceModel.this.z2Min) || v2 < DefaultSurfaceModel.this.z2Min) {
                                    DefaultSurfaceModel.this.z2Min = v2;
                                }
                            }
                            DefaultSurfaceModel.this.surfaceVertex[1][k] = new SurfaceVertex((x - DefaultSurfaceModel.this.xMin) * xfactor - 10.0f, (y - DefaultSurfaceModel.this.yMin) * yfactor - 10.0f, v2);
                        }
                        this.publish(new Void[0]);
                        this.setProgress(100 * k / total);
                    }
                }
                this.setProgress(100);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                DefaultSurfaceModel.this.z1Min = (float)AbstractSurfaceModel.floor(DefaultSurfaceModel.this.z1Min, 2);
                DefaultSurfaceModel.this.z1Max = (float)AbstractSurfaceModel.ceil(DefaultSurfaceModel.this.z1Max, 2);
                DefaultSurfaceModel.this.z2Min = (float)AbstractSurfaceModel.floor(DefaultSurfaceModel.this.z2Min, 2);
                DefaultSurfaceModel.this.z2Max = (float)AbstractSurfaceModel.ceil(DefaultSurfaceModel.this.z2Max, 2);
                DefaultSurfaceModel.this.autoScale();
                DefaultSurfaceModel.this.fireStateChanged();
            }

            @Override
            protected void process(List<Void> chunks) {
                DefaultSurfaceModel.this.fireStateChanged();
            }
        };
    }

    private SurfaceVertex[][] allocateMemory(boolean f1, boolean f2, int total) {
        SurfaceVertex[][] vertex = null;
        try {
            vertex = new SurfaceVertex[2][total];
            if (!f1) {
                vertex[0] = null;
            }
            if (!f2) {
                vertex[1] = null;
            }
        }
        catch (OutOfMemoryError e) {
            this.setMessage("Not enough memory");
        }
        catch (Exception e) {
            this.setMessage("Error: " + e.toString());
        }
        return vertex;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    @Override
    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
        this.getPropertyChangeSupport().firePropertyChange("mapper", this.mapper, this.mapper);
    }

    @Override
    public SurfaceVertex[][] getSurfaceVertex() {
        return this.surfaceVertex;
    }

    protected void setSurfaceVertex(SurfaceVertex[][] surfaceVertex) {
        this.surfaceVertex = surfaceVertex;
        this.getPropertyChangeSupport().firePropertyChange("surfaceVertex", this.surfaceVertex, surfaceVertex);
    }
}

