/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.surfaceplotter;

import java.util.List;
import javax.swing.SwingWorker;
import net.ericaro.surfaceplotter.Mapper;
import net.ericaro.surfaceplotter.surface.AbstractSurfaceModel;
import net.ericaro.surfaceplotter.surface.SurfaceModel;
import net.ericaro.surfaceplotter.surface.SurfaceVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressiveSurfaceModel
extends AbstractSurfaceModel
implements SurfaceModel {
    protected SurfaceVertex[][] highDefinitionVertex;
    protected SurfaceVertex[][] surfaceVertex;
    protected Mapper mapper;
    int currentDefinition = -1;
    int availableDefinition = -1;
    int maxDefinition = 6;

    @Override
    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public SwingWorker<Void, Void> plot() {
        return this.plot(null);
    }

    public SwingWorker<Void, Void> plot(final Runnable callback) {
        this.highDefinitionVertex = this.allocateMemory(this.hasFunction1, this.hasFunction2, this.maxDefinition);
        this.currentDefinition = -1;
        this.availableDefinition = -1;
        return new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                this.setProgress(0);
                while (ProgressiveSurfaceModel.this.maxDefinition > ProgressiveSurfaceModel.this.availableDefinition) {
                    this.increaseDefinition();
                    if (this.isCancelled()) {
                        return null;
                    }
                    this.publish(new Void[0]);
                }
                this.setProgress(100);
                return null;
            }

            @Override
            protected void process(List<Void> chunks) {
                ProgressiveSurfaceModel.this.setCurrentDefinition(ProgressiveSurfaceModel.this.availableDefinition);
            }

            private void increaseDefinition() throws Exception {
                int def = ProgressiveSurfaceModel.this.availableDefinition + 1;
                int max = 2 + ProgressiveSurfaceModel.vertices(def) - ProgressiveSurfaceModel.vertices(def - 1);
                int ci = 1;
                this.setProgress(ci);
                int k = ProgressiveSurfaceModel.segments(ProgressiveSurfaceModel.this.maxDefinition) + 1;
                for (int i = 0; i < k; ++i) {
                    for (int j = 0; j < k; ++j) {
                        if (ProgressiveSurfaceModel.this.definition(i, j) != def) continue;
                        if (this.isCancelled()) {
                            return;
                        }
                        ProgressiveSurfaceModel.this.compute(i, j);
                        this.setProgress(ci++ * 100 / max);
                    }
                }
                ProgressiveSurfaceModel.this.availableDefinition = def;
                ProgressiveSurfaceModel.this.z1Min = (float)AbstractSurfaceModel.floor(ProgressiveSurfaceModel.this.z1Min, 2);
                ProgressiveSurfaceModel.this.z1Max = (float)AbstractSurfaceModel.ceil(ProgressiveSurfaceModel.this.z1Max, 2);
                ProgressiveSurfaceModel.this.z2Min = (float)AbstractSurfaceModel.floor(ProgressiveSurfaceModel.this.z2Min, 2);
                ProgressiveSurfaceModel.this.z2Max = (float)AbstractSurfaceModel.ceil(ProgressiveSurfaceModel.this.z2Max, 2);
            }

            @Override
            protected void done() {
                if (callback != null) {
                    callback.run();
                }
            }
        };
    }

    private SurfaceVertex[][] extractResolution(int def) {
        SurfaceVertex[][] vertex = this.allocateMemory(this.hasFunction1, this.hasFunction2, def);
        int k = ProgressiveSurfaceModel.segments(def) + 1;
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < k; ++j) {
                this.copy(i, j, def, vertex);
            }
        }
        return vertex;
    }

    private void copy(int i, int j, int def, SurfaceVertex[][] vertex) {
        int offset = this.maxDefinition - def;
        int hi = i << offset;
        int hj = j << offset;
        int k = i * (ProgressiveSurfaceModel.segments(def) + 1) + j;
        int hk = hi * (ProgressiveSurfaceModel.segments(this.maxDefinition) + 1) + hj;
        vertex[0][k] = this.highDefinitionVertex[0][hk];
        vertex[1][k] = this.highDefinitionVertex[1][hk];
    }

    private void compute(int i, int j) {
        int steps = ProgressiveSurfaceModel.segments(this.maxDefinition);
        float xWidth = this.xMax - this.xMin;
        float yWidth = this.yMax - this.yMin;
        float x = this.xMin + (float)i * xWidth / (float)steps;
        float y = this.yMin + (float)j * yWidth / (float)steps;
        float xfactor = 20.0f / xWidth;
        float yfactor = 20.0f / yWidth;
        int k = i * (steps + 1) + j;
        if (this.hasFunction1) {
            float f1 = this.mapper.f1(x, y);
            if (Float.isInfinite(f1)) {
                f1 = Float.NaN;
            }
            if (!Float.isNaN(f1)) {
                if (Float.isNaN(this.z1Max) || f1 > this.z1Max) {
                    this.z1Max = f1;
                } else if (Float.isNaN(this.z1Min) || f1 < this.z1Min) {
                    this.z1Min = f1;
                }
            }
            this.highDefinitionVertex[0][k] = new SurfaceVertex((x - this.xMin) * xfactor - 10.0f, (y - this.yMin) * yfactor - 10.0f, f1);
        }
        if (this.hasFunction2) {
            float f2 = this.mapper.f2(x, y);
            if (Float.isInfinite(f2)) {
                f2 = Float.NaN;
            }
            if (!Float.isNaN(f2)) {
                if (Float.isNaN(this.z2Max) || f2 > this.z2Max) {
                    this.z2Max = f2;
                } else if (Float.isNaN(this.z2Min) || f2 < this.z2Min) {
                    this.z2Min = f2;
                }
            }
            this.highDefinitionVertex[1][k] = new SurfaceVertex((x - this.xMin) * xfactor - 10.0f, (y - this.yMin) * yfactor - 10.0f, f2);
        }
    }

    private SurfaceVertex[][] allocateMemory(boolean f1, boolean f2, int def) {
        SurfaceVertex[][] vertex = null;
        int total = ProgressiveSurfaceModel.vertices(def);
        try {
            vertex = new SurfaceVertex[2][total];
            if (!f1) {
                vertex[0] = null;
            }
            if (!f2) {
                vertex[1] = null;
            }
        }
        catch (OutOfMemoryError e) {
            this.setMessage("Not enough memory");
        }
        catch (Exception e) {
            this.setMessage("Error: " + e.toString());
        }
        return vertex;
    }

    public int definition(int i, int j) {
        int offset = Math.min(Long.numberOfTrailingZeros(i), Long.numberOfTrailingZeros(j));
        return Math.max(0, this.maxDefinition - offset);
    }

    public static final int faces(int def) {
        int segPerDim = ProgressiveSurfaceModel.segments(def);
        return segPerDim * segPerDim;
    }

    public static final int segments(int def) {
        return 1 << def;
    }

    public static final int vertices(int def) {
        int dotsPerDim = ProgressiveSurfaceModel.segments(def) + 1;
        return dotsPerDim * dotsPerDim;
    }

    @Override
    public SurfaceVertex[][] getSurfaceVertex() {
        return this.surfaceVertex;
    }

    protected void setSurfaceVertex(SurfaceVertex[][] surfaceVertex) {
        this.surfaceVertex = surfaceVertex;
        this.getPropertyChangeSupport().firePropertyChange("surfaceVertex", this.surfaceVertex, surfaceVertex);
    }

    public int getCurrentDefinition() {
        return this.currentDefinition;
    }

    public void setCurrentDefinition(int currentDefinition) {
        assert (currentDefinition <= this.maxDefinition && currentDefinition <= this.availableDefinition) : "cannot change definition higher than " + this.maxDefinition;
        SurfaceVertex[][] vertex = this.extractResolution(currentDefinition);
        this.currentDefinition = currentDefinition;
        this.getPropertyChangeSupport().firePropertyChange("currentDefinition", this.currentDefinition, this.currentDefinition);
        int step = ProgressiveSurfaceModel.segments(currentDefinition);
        this.setSurfaceVertex(vertex);
        this.setCalcDivisions(step);
        this.setDispDivisions(step);
        if (currentDefinition >= 0) {
            this.setDataAvailable(true);
        }
        this.autoScale();
        this.fireStateChanged();
    }
}

