/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.surfaceplotter.beans;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class JScrollablePanel
extends JPanel
implements Scrollable {
    private int blockIncrement = 5;

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public void setBlockIncrement(int blockIncrement) {
        this.blockIncrement = blockIncrement;
    }

    public JScrollablePanel() {
    }

    public JScrollablePanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public JScrollablePanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public JScrollablePanel(LayoutManager layout) {
        super(layout);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.blockIncrement * this.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.getLayout() instanceof GridBagLayout) {
            GridBagLayout layout = (GridBagLayout)this.getLayout();
            Point p = layout.location(visibleRect.x, visibleRect.y);
            int[][] dims = layout.getLayoutDimensions();
            Point origin = layout.getLayoutOrigin();
            if (orientation == 1) {
                p.y = direction < 0 ? --p.y : ++p.y;
                if (p.y < dims[1].length && p.y >= 0) {
                    int pos = origin.y;
                    for (int i = 0; i < p.y; ++i) {
                        pos += dims[1][i];
                    }
                    return Math.abs(pos - visibleRect.y);
                }
                return this.getSize().height / dims[1].length;
            }
            p.x = direction < 0 ? --p.x : ++p.x;
            if (p.x < dims[0].length && p.x >= 0) {
                int pos = origin.x;
                for (int i = 0; i < p.x; ++i) {
                    pos += dims[0][i];
                }
                return Math.abs(pos - visibleRect.x);
            }
            return this.getSize().width / dims[0].length;
        }
        return 1;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }
}

