/*
 * Decompiled with CFR 0.152.
 */
package org.javadev.effects;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.javadev.effects.Animation;
import org.javadev.effects.AnimationListener;
import org.javadev.effects.DashboardAnimation;

public class DashboardAnimation
implements Animation {
    SpecialPanel animationPanel = null;
    private AnimationListener listener = null;
    boolean direction = true;
    int animationDuration = 2000;

    public void setDirection(boolean direction) {
        this.direction = direction;
    }

    public void setAnimationDuration(int animationDuration) {
        this.animationDuration = animationDuration < 1000 ? 1000 : animationDuration;
    }

    public Component animate(Component toHide, Component toShow, AnimationListener listener) {
        this.listener = listener;
        this.animationPanel = new SpecialPanel(this, this.direction ? toHide : toShow, this.direction ? toShow : toHide);
        this.animationPanel.beginAngle = this.direction ? 0 : 180;
        this.animationPanel.endAngle = this.direction ? 180 : 0;
        this.animationPanel.needToStartThread = true;
        this.animationPanel.setAnimationDuration(this.animationDuration);
        return this.animationPanel;
    }

    public Component getAnimationPanel() {
        return this.animationPanel;
    }

    void rotationFinished() {
        SwingUtilities.invokeLater(new 1());
    }

    private final class 1
    implements Runnable {
        public void run() {
            DashboardAnimation.this.animationPanel = null;
            DashboardAnimation.this.listener.animationFinished();
            DashboardAnimation.this.listener = null;
        }

        /* synthetic */ 1() {
        }
    }

    class SpecialOp
    implements BufferedImageOp {
        double angle = 0.0;
        double epsilon = 0.3f;
        double cosa = Math.cos(Math.PI * this.angle / 180.0);
        double sinea = Math.sin(Math.PI * this.epsilon * this.angle / 180.0);
        boolean positiveDirection = false;
        int[] pixels = null;
        int[] destPixels = null;
        private Object kernelLock = new Object();
        BufferedImageOp convOp = null;
        BufferedImage dest1;

        SpecialOp() {
            this(0.0);
        }

        SpecialOp(double angle) {
            this.setAngle(angle);
            this.setConvOp(1, 20.0f, 1.0f);
        }

        public void setAngle(double angle) {
            this.angle = angle;
            this.cosa = Math.cos(Math.PI * angle / 180.0);
            this.sinea = Math.sin(Math.PI * this.epsilon * angle / 180.0);
        }

        public void setPositiveDirection(boolean positiveDirection) {
            this.positiveDirection = positiveDirection;
        }

        public void setPixels(int[] pixels) {
            this.pixels = pixels;
            this.destPixels = (int[])(pixels == null ? null : new int[pixels.length]);
        }

        public synchronized BufferedImage filter(BufferedImage src, BufferedImage dest) {
            if (dest == null && this.destPixels == null) {
                dest = this.createCompatibleDestImage(src, null);
            }
            int w = src.getWidth();
            int h = src.getHeight();
            double kw = (double)w * (1.0 - this.cosa);
            double k1 = this.sinea / (double)w;
            double xx = kw;
            int x = 0;
            while (x < w) {
                int k = this.positiveDirection ? x : w - x;
                double k2 = 1.0 - k1 * (double)k;
                double k3 = (1.0 - k2) * (double)h / 2.0;
                int currIndex = x;
                double yy = k3;
                int y = 0;
                while (y < h) {
                    int px = this.pixels == null ? src.getRGB(x, y) : this.pixels[currIndex];
                    int iyy = (int)yy;
                    int ixx = (int)xx;
                    if (ixx >= 0 && ixx < w && iyy >= 0 && iyy < h) {
                        if (this.destPixels == null) {
                            dest.setRGB(ixx, iyy, px);
                        } else {
                            this.destPixels[iyy * w + ixx] = px;
                        }
                    }
                    currIndex += w;
                    yy += k2;
                    ++y;
                }
                xx += this.cosa;
                ++x;
            }
            if (this.destPixels != null && dest == null) {
                MemoryImageSource source = new MemoryImageSource(w, h, this.destPixels, 0, w);
                Image img = Toolkit.getDefaultToolkit().createImage(source);
                if (this.dest1 == null) {
                    this.dest1 = new BufferedImage(w, h, src.getType());
                }
                Graphics2D g2d = this.dest1.createGraphics();
                Composite oldComp = g2d.getComposite();
                Color oldColor = g2d.getColor();
                g2d.setComposite(AlphaComposite.getInstance(1, 0.0f));
                g2d.setColor(Color.white);
                g2d.fillRect(0, 0, w, h);
                g2d.setComposite(oldComp);
                g2d.setColor(oldColor);
                g2d.drawImage(img, 0, 0, null);
                g2d.dispose();
                dest = this.dest1;
            }
            return dest;
        }

        public Rectangle2D getBounds2D(BufferedImage src) {
            return src.getRaster().getBounds();
        }

        public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
            if (destCM == null) {
                destCM = src.getColorModel();
            }
            int w = src.getWidth();
            int h = src.getHeight();
            return new BufferedImage(destCM, destCM.createCompatibleWritableRaster(w, h), destCM.isAlphaPremultiplied(), null);
        }

        public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
            if (dstPt == null) {
                dstPt = new Point2D.Float();
            }
            dstPt.setLocation(srcPt);
            return dstPt;
        }

        public RenderingHints getRenderingHints() {
            return null;
        }

        public void setConvOp(int dimensionOrder, float centralValue, float sideValue) {
            float kernelCenter = centralValue;
            float kernelOuter = sideValue;
            int dimension = 2 * dimensionOrder + 1;
            int matrixSize = dimension * dimension;
            float summ = (float)(matrixSize - 1) * sideValue + centralValue;
            if (summ == 0.0f) {
                kernelCenter = 1.0f;
                kernelOuter = 0.0f;
                summ = 1.0f;
            }
            float[] values = new float[matrixSize];
            int centralIndex = matrixSize / 2;
            int i = 0;
            while (i < matrixSize) {
                values[i] = i == centralIndex ? centralValue / summ : sideValue / summ;
                ++i;
            }
            Object object = this.kernelLock;
            synchronized (object) {
                Kernel kernel = new Kernel(dimension, dimension, values);
                if (kernel != null) {
                    this.convOp = new ConvolveOp(kernel);
                }
            }
        }
    }

    class SpecialPanel
    extends JPanel {
        DashboardAnimation owner;
        BasicStroke stroke2 = new BasicStroke(2.0f);
        BasicStroke stroke1 = new BasicStroke(1.0f);
        BufferedImage firstImage;
        BufferedImage secondImage;
        Component component1;
        Component component2;
        int[] firstPixels;
        int[] secondPixels;
        SpecialOp op;
        double angle = 0.0;
        public double beginAngle = 0.0;
        public double endAngle = 360.0;
        double deltaAngle = 0.5;
        double effectTime = 2000.0;
        long dt = Math.round(this.effectTime * this.deltaAngle / 180.0);
        int counter = 0;
        long totalDrawTime = 0L;
        public boolean needToStartThread = false;
        private long startTime = 0L;

        SpecialPanel(DashboardAnimation owner, BufferedImage firstImage, BufferedImage secondImage) {
            this.owner = owner;
            this.firstImage = firstImage;
            this.secondImage = secondImage;
            this.angle = this.beginAngle;
            DashboardAnimation dashboardAnimation = DashboardAnimation.this;
            dashboardAnimation.getClass();
            this.op = dashboardAnimation.new SpecialOp(this.angle);
            this.setOpaque(false);
        }

        SpecialPanel(DashboardAnimation owner, Component component1, Component component2) {
            this.owner = owner;
            this.component1 = component1;
            this.component2 = component2;
            this.angle = this.beginAngle;
            DashboardAnimation dashboardAnimation = DashboardAnimation.this;
            dashboardAnimation.getClass();
            this.op = dashboardAnimation.new SpecialOp(this.angle);
            this.setOpaque(false);
            this.firstImage = this.createImageFromComponent(component1);
            this.firstPixels = this.createPixels(this.firstImage);
            this.secondImage = this.createImageFromComponent(component2);
            this.secondPixels = this.createPixels(this.secondImage);
        }

        public void setAnimationDuration(int animationDuration) {
            this.effectTime = animationDuration < 1000 ? 1000 : animationDuration;
            this.dt = Math.round(this.effectTime * this.deltaAngle / 180.0);
        }

        void startThread(double val1, double val2) {
            this.counter = 0;
            this.totalDrawTime = 0L;
            this.beginAngle = val1;
            this.endAngle = val2;
            this.deltaAngle = this.endAngle < this.beginAngle ? -Math.abs(this.deltaAngle) : Math.abs(this.deltaAngle);
            this.angle = this.beginAngle;
            2 repaint = new 2(this);
            Thread t = new Thread(new 3(this));
            t.start();
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public synchronized void paint(Graphics g) {
            if (this.needToStartThread) {
                this.totalDrawTime = 0L;
                this.counter = 0;
                this.needToStartThread = false;
                this.startThread(this.beginAngle, this.endAngle);
                this.angle = this.beginAngle;
                this.startTime = System.currentTimeMillis();
            }
            long time = System.currentTimeMillis();
            double oldAngle = this.angle;
            this.angle += this.deltaAngle * (double)(time - this.startTime) / (double)this.dt;
            if (this.angle >= this.endAngle && this.deltaAngle > 0.0 || this.angle <= this.endAngle && this.deltaAngle < 0.0) {
                this.angle = this.endAngle;
            }
            this.startTime = time;
            if (this.firstImage == null || this.secondImage == null) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            int ww = this.firstImage.getWidth();
            int hh = this.firstImage.getHeight();
            BufferedImage currImage = null;
            int[] currPixels = null;
            double needAngle = 180.0 - this.angle > 1.0 || this.angle > 1.0 ? this.angle : oldAngle;
            boolean needDirection = false;
            if (this.angle >= 0.0 && this.angle < 90.0) {
                currImage = this.firstImage;
                currPixels = this.firstPixels;
            } else {
                currImage = this.secondImage;
                currPixels = this.secondPixels;
            }
            if (this.angle >= 90.0 && this.angle < 180.0) {
                needAngle = 180.0 - this.angle;
                needDirection = true;
            }
            if (currImage != null) {
                double cosa = Math.cos(Math.PI * needAngle / 180.0);
                this.op.setAngle(needAngle);
                this.op.setPositiveDirection(needDirection);
                this.op.setPixels(currPixels);
                long beforeDraw = System.currentTimeMillis();
                g2d.drawImage(currImage, this.op, -((int)Math.round((double)ww * (1.0 - cosa) / 2.0)), 0);
                this.totalDrawTime += System.currentTimeMillis() - beforeDraw;
                ++this.counter;
                this.op.setPixels(null);
            }
        }

        BufferedImage createImageFromComponent(Component comp) {
            BufferedImage retImage = null;
            if (comp == null) {
                return retImage;
            }
            try {
                GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gd = genv.getDefaultScreenDevice();
                GraphicsConfiguration gc = gd.getDefaultConfiguration();
                ColorModel cm = gc.getColorModel();
                boolean hasAlpha = cm.hasAlpha();
                int cw = comp.getSize().width;
                int ch = comp.getSize().height;
                retImage = hasAlpha ? gc.createCompatibleImage(cw, ch) : new BufferedImage(cw, ch, 2);
                if (retImage == null) {
                    return retImage;
                }
                Graphics og = retImage.getGraphics();
                comp.paint(og);
                og.dispose();
            }
            catch (Throwable throwable) {}
            return retImage;
        }

        int[] createPixels(BufferedImage bim) {
            int[] pixels = null;
            if (bim == null) {
                return pixels;
            }
            int ww = bim.getWidth();
            int hh = bim.getHeight();
            pixels = new int[ww * hh];
            PixelGrabber pg = new PixelGrabber(bim, 0, 0, ww, hh, pixels, 0, ww);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            if ((pg.getStatus() & 0x80) != 0) {
                return null;
            }
            return pixels;
        }
    }
}

