/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.annotation;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.PageList;
import com.jidesoft.wizard.AbstractWizardPage;
import com.jidesoft.wizard.CompletionWizardPage;
import com.jidesoft.wizard.DefaultWizardPage;
import com.jidesoft.wizard.WizardDialog;
import com.jidesoft.wizard.WizardStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.ClientNetworkUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.PathField;
import org.ut.biolab.medsavant.client.view.component.ProgressWheel;
import org.ut.biolab.medsavant.client.view.component.StripyTable;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.AnnotationDownloadInformation;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.util.ExtensionFileFilter;
import org.ut.biolab.medsavant.shared.util.VersionSettings;

public class InstallAnnotationWizard
extends WizardDialog {
    private static final Log LOG = LogFactory.getLog(InstallAnnotationWizard.class);
    private static final String PAGENAME_SRC = "Annotation Source";
    private static final String PAGENAME_CHOOSE = "Choose Annotation";
    private static final String PAGENAME_INSTALL = "Install Annotation";
    private static final String PAGENAME_COMPLETE = "Complete";
    private JPanel chooseContainer;
    private JLabel chooseTitleLabel;
    private JPanel repoChoosePanel;
    private PathField fileChoosePanel;
    private JLabel progressLabel;
    private boolean fromRepository;
    private AnnotationDownloadInformation annotationToInstall;
    private HashMap<String, AnnotationDownloadInformation> annotationKeyToURLMap;
    private boolean hasAnnotations = false;

    public InstallAnnotationWizard() throws RemoteException {
        super((Frame)DialogUtils.getFrontWindow(), "Install Annotations", true);
        WizardStyle.setStyle((int)3);
        PageList model = new PageList();
        model.append((AbstractDialogPage)this.getChoosePage());
        model.append((AbstractDialogPage)this.getInstallPage());
        model.append((AbstractDialogPage)this.getCompletionPage());
        this.setPageList(model);
        this.setNextAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String pageName = InstallAnnotationWizard.this.getCurrentPage().getTitle();
                if (pageName.equals(InstallAnnotationWizard.PAGENAME_SRC)) {
                    InstallAnnotationWizard.this.setCurrentPage(InstallAnnotationWizard.PAGENAME_CHOOSE);
                } else if (pageName.equals(InstallAnnotationWizard.PAGENAME_CHOOSE)) {
                    InstallAnnotationWizard.this.setCurrentPage(InstallAnnotationWizard.PAGENAME_INSTALL);
                } else if (pageName.equals(InstallAnnotationWizard.PAGENAME_INSTALL)) {
                    InstallAnnotationWizard.this.setCurrentPage(InstallAnnotationWizard.PAGENAME_COMPLETE);
                }
            }
        });
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(DialogUtils.getFrontWindow());
    }

    private void setSourceFromRepo(boolean fromRepo, final DefaultWizardPage page) {
        this.fromRepository = fromRepo;
        if (this.chooseContainer != null) {
            this.chooseContainer.removeAll();
            if (this.fromRepository) {
                this.chooseTitleLabel.setText("Choose annotation from repository:");
                this.chooseContainer.add((Component)this.repoChoosePanel, "Center");
                JButton fromFile = new JButton("Install from file");
                fromFile.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        InstallAnnotationWizard.this.chooseContainer.removeAll();
                        InstallAnnotationWizard.this.chooseTitleLabel.setText("Choose annotation from file:");
                        InstallAnnotationWizard.this.chooseContainer.add((Component)InstallAnnotationWizard.this.fileChoosePanel, "Center");
                        InstallAnnotationWizard.this.fromRepository = false;
                        String s = InstallAnnotationWizard.this.fileChoosePanel.getTextField().getText();
                        if (s == null || s.length() < 1) {
                            page.fireButtonEvent(3302, "NEXT");
                        }
                        InstallAnnotationWizard.this.chooseContainer.updateUI();
                    }
                });
                this.chooseContainer.add((Component)ViewUtil.alignLeft(fromFile), "South");
            } else {
                this.chooseTitleLabel.setText("Choose annotation from file:");
                this.chooseContainer.add((Component)this.fileChoosePanel, "Center");
            }
        }
    }

    @Deprecated
    private AbstractWizardPage getAnnotationSourcePage() {
        return new DefaultWizardPage(PAGENAME_SRC){
            private JRadioButton radioFromRepo;
            private JRadioButton radioFromFile;
            {
                this.radioFromRepo = new JRadioButton("MedSavant public repository");
                this.radioFromFile = new JRadioButton("file (for custom annotations)");
                ButtonGroup g = new ButtonGroup();
                g.add(this.radioFromRepo);
                final 3 instance = this;
                this.radioFromRepo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        InstallAnnotationWizard.this.setSourceFromRepo(radioFromRepo.isSelected(), instance);
                    }
                });
                this.radioFromFile.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        InstallAnnotationWizard.this.setSourceFromRepo(radioFromRepo.isSelected(), instance);
                    }
                });
                this.addText("Install annotation from:");
                this.addComponent(this.radioFromRepo);
                this.addComponent(this.radioFromFile);
                this.radioFromRepo.setSelected(true);
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3299, "NEXT");
            }
        };
    }

    private AbstractWizardPage getChoosePage() {
        return new DefaultWizardPage(PAGENAME_CHOOSE){
            {
                InstallAnnotationWizard.this.chooseContainer = ViewUtil.getClearPanel();
                InstallAnnotationWizard.this.chooseContainer.setLayout(new BorderLayout());
                InstallAnnotationWizard.this.chooseTitleLabel = new JLabel();
                InstallAnnotationWizard.this.repoChoosePanel = InstallAnnotationWizard.this.populateRepositoryPanel(this);
                InstallAnnotationWizard.this.fileChoosePanel = new PathField(0);
                InstallAnnotationWizard.this.fileChoosePanel.setFileFilters(ExtensionFileFilter.createFilters(new String[]{"gz", "zip"}));
                InstallAnnotationWizard.this.fileChoosePanel.getTextField().addCaretListener(new CaretListener(){

                    @Override
                    public void caretUpdate(CaretEvent ce) {
                        if (!InstallAnnotationWizard.this.fileChoosePanel.getTextField().getText().isEmpty()) {
                            this.fireButtonEvent(3301, "NEXT");
                        } else {
                            this.fireButtonEvent(3302, "NEXT");
                        }
                    }
                });
                this.addComponent(InstallAnnotationWizard.this.chooseTitleLabel);
                this.addComponent(InstallAnnotationWizard.this.chooseContainer);
                InstallAnnotationWizard.this.setSourceFromRepo(true, this);
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3299, "NEXT");
                if (!InstallAnnotationWizard.this.hasAnnotations) {
                    this.fireButtonEvent(3302, "NEXT");
                }
            }
        };
    }

    private static String keyForAnnotationInfo(AnnotationDownloadInformation i) {
        return InstallAnnotationWizard.keyForAnnotationInfo(i.getReference(), i.getProgramName(), i.getProgramVersion());
    }

    private static String keyForAnnotationInfo(String ref, String prog, String ver) {
        return ref + "_" + prog + "_" + ver;
    }

    private JPanel populateRepositoryPanel(DefaultWizardPage page) {
        JPanel p = ViewUtil.getClearPanel();
        p.setLayout(new BorderLayout());
        try {
            List<AnnotationDownloadInformation> annotationsAvailable = AnnotationDownloadInformation.getDownloadableAnnotations(VersionSettings.getVersionString());
            if (annotationsAvailable == null) {
                p.add((Component)new JLabel("No annotations are available for this version"), "North");
                return p;
            }
            Object[][] data = new Object[annotationsAvailable.size()][4];
            this.annotationKeyToURLMap = new HashMap();
            int i = 0;
            for (AnnotationDownloadInformation a : annotationsAvailable) {
                data[i][0] = a.getReference();
                data[i][1] = a.getProgramName();
                data[i][2] = a.getProgramVersion();
                data[i][3] = a.getDescription();
                this.annotationKeyToURLMap.put(InstallAnnotationWizard.keyForAnnotationInfo(a), a);
                ++i;
            }
            LOG.info((Object)(annotationsAvailable.size() + " annotations are available"));
            StripyTable stp = new StripyTable(data, new String[]{"Reference", "Annotation", "Version", "Description"});
            stp.setBorder(null);
            stp.setShowGrid(false);
            stp.setRowHeight(21);
            SelectionListener listener = new SelectionListener(stp);
            stp.getSelectionModel().addListSelectionListener(listener);
            p.add((Component)stp.getTableHeader(), "North");
            p.add((Component)ViewUtil.getClearBorderedScrollPane(stp), "Center");
            stp.addRowSelectionInterval(0, 0);
            if (!annotationsAvailable.isEmpty()) {
                page.fireButtonEvent(3301, "NEXT");
                this.hasAnnotations = true;
            }
        }
        catch (Exception ex) {
            p.add(ViewUtil.getErrorLabel("Problem fetching available annotations"));
            LOG.error((Object)ex);
        }
        return p;
    }

    private AbstractWizardPage getInstallPage() {
        return new DefaultWizardPage(PAGENAME_INSTALL){
            private ProgressWheel progressWheel;
            private JButton startButton;
            {
                InstallAnnotationWizard.this.progressLabel = new JLabel("You are now ready to install this annotation.");
                this.addComponent(InstallAnnotationWizard.this.progressLabel);
                this.progressWheel = new ProgressWheel();
                this.progressWheel.setVisible(false);
                this.addComponent(this.progressWheel);
                this.startButton = new JButton(InstallAnnotationWizard.PAGENAME_INSTALL);
                this.startButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        startButton.setEnabled(false);
                        this.fireButtonEvent(3302, "BACK");
                        progressWheel.setIndeterminate(true);
                        progressWheel.setVisible(true);
                        new MedSavantWorker<Void>("Annotations"){
                            private boolean success;

                            @Override
                            public Void doInBackground() throws Exception {
                                this.success = InstallAnnotationWizard.this.create();
                                return null;
                            }

                            @Override
                            protected void showProgress(double fraction) {
                            }

                            @Override
                            protected void showSuccess(Void result) {
                                progressWheel.setVisible(false);
                                InstallAnnotationWizard.this.progressLabel.setText("Done");
                                if (this.success) {
                                    ((CompletionWizardPage)InstallAnnotationWizard.this.getPageByTitle(InstallAnnotationWizard.PAGENAME_COMPLETE)).addText("Annotation has been successfully installed.\n\nYou can apply this annotation to a project by\nediting project settings.");
                                } else {
                                    ((CompletionWizardPage)InstallAnnotationWizard.this.getPageByTitle(InstallAnnotationWizard.PAGENAME_COMPLETE)).addText("Annotation could not be installed.\n\nEither this annotation is already installed or the\ninstallation package is invalid.");
                                }
                                InstallAnnotationWizard.this.setCurrentPage(InstallAnnotationWizard.PAGENAME_COMPLETE);
                            }

                            @Override
                            protected void showFailure(Throwable t) {
                                InstallAnnotationWizard.this.setVisible(false);
                                LOG.error((Object)"Error installing annotation.", t);
                                DialogUtils.displayException("Error", "There was an error while trying to install this annotation.", t);
                            }
                        }.execute();
                    }
                });
                this.addComponent(ViewUtil.alignRight(this.startButton));
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3299, "NEXT");
                this.fireButtonEvent(3302, "NEXT");
            }
        };
    }

    private AbstractWizardPage getCompletionPage() {
        return new CompletionWizardPage(PAGENAME_COMPLETE){

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3301, "FINISH");
                this.fireButtonEvent(3300, "NEXT");
            }
        };
    }

    private boolean create() throws SQLException, IOException, InterruptedException, ExecutionException {
        try {
            if (this.fromRepository) {
                this.progressLabel.setText("Installing annotation...");
                return MedSavantClient.AnnotationManagerAdapter.installAnnotationForProject(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), this.annotationToInstall);
            }
            this.progressLabel.setText("Uploading file to server...");
            File annotationFile = new File(this.fileChoosePanel.getPath());
            int transferID = ClientNetworkUtils.copyFileToServer(annotationFile);
            this.progressLabel.setText("Installing annotation...");
            return MedSavantClient.AnnotationManagerAdapter.installAnnotationForProject(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), transferID);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return false;
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                int first = this.table.getSelectedRows()[0];
                String ref = (String)this.table.getValueAt(first, 0);
                String annotation = (String)this.table.getValueAt(first, 1);
                String version = (String)this.table.getValueAt(first, 2);
                InstallAnnotationWizard.this.annotationToInstall = (AnnotationDownloadInformation)InstallAnnotationWizard.this.annotationKeyToURLMap.get(InstallAnnotationWizard.keyForAnnotationInfo(ref, annotation, version));
            }
        }
    }
}

