/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.cohort;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.filter.SearchBar;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.query.QueryViewController;
import org.ut.biolab.medsavant.client.query.SearchConditionGroupItem;
import org.ut.biolab.medsavant.client.query.value.encode.StringConditionEncoder;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.BlockingPanel;
import org.ut.biolab.medsavant.client.view.component.StripyTable;
import org.ut.biolab.medsavant.client.view.font.FontFactory;
import org.ut.biolab.medsavant.client.view.genetics.QueryUtils;
import org.ut.biolab.medsavant.client.view.list.DetailedView;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.StandardFixableWidthAppPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.Cohort;
import org.ut.biolab.medsavant.shared.model.SimplePatient;
import org.ut.biolab.medsavant.shared.util.MiscUtils;

class CohortDetailedView
extends DetailedView {
    private static final Log LOG = LogFactory.getLog(CohortDetailedView.class);
    private Cohort[] cohorts;
    private CohortDetailsWorker worker;
    private JTable list;
    private final BlockingPanel blockPanel;
    private final JPanel members;
    private final StandardFixableWidthAppPanel canvas = new StandardFixableWidthAppPanel("Cohort");

    CohortDetailedView(String page) {
        super(page);
        this.members = this.canvas.addBlock("Members");
        this.blockPanel = new BlockingPanel("No cohort selected", this.canvas);
        this.setLayout(new BorderLayout());
        this.add((Component)this.blockPanel, "Center");
    }

    public JPopupMenu createHospitalPopup(final String[] hospitalIds) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem filter1Item = new JMenuItem(String.format("<html>Filter by %s</html>", hospitalIds.length == 1 ? "Hospital ID <i>" + hospitalIds[0] + "</i>" : "Selected Hospital IDs"));
        filter1Item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cohort = null;
                if (CohortDetailedView.this.cohorts.length == 1) {
                    cohort = CohortDetailedView.this.cohorts[0].getName();
                }
                QueryUtils.addQueryOnHospitals(hospitalIds, cohort);
                DialogUtils.displayMessage("Selected Cohort and Hospital IDS have been added to query.  Click 'Variants' to review and execute search.");
            }
        });
        popupMenu.add(filter1Item);
        return popupMenu;
    }

    public synchronized void setPatientList(List<SimplePatient> patients) {
        this.members.removeAll();
        final Object[][] data = new Object[patients.size()][1];
        for (int i = 0; i < patients.size(); ++i) {
            data[i][0] = patients.get(i);
        }
        this.list = new StripyTable(data, new String[]{"Member Hospital IDs"});
        this.list.setFont(FontFactory.getGeneralFont().deriveFont(16));
        this.list.setBorder(null);
        this.list.setShowGrid(false);
        this.list.setRowHeight(21);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int[] selection = CohortDetailedView.this.list.getSelectedRows();
                    String[] hosIds = new String[selection.length];
                    for (int i = 0; i < selection.length; ++i) {
                        int j = CohortDetailedView.this.list.convertRowIndexToModel(selection[i]);
                        hosIds[i] = ((SimplePatient)data[j][0]).getHospitalId();
                    }
                    CohortDetailedView.this.createHospitalPopup(hosIds).show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        final JButton removeButton = this.removeIndividualsButton();
        removeButton.setEnabled(false);
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int count = CohortDetailedView.this.list.getSelectedRowCount();
                removeButton.setEnabled(count > 0);
                if (count == 0) {
                    removeButton.setText("Remove selected member");
                } else if (count == 1) {
                    removeButton.setText("Remove selected member");
                } else {
                    removeButton.setText(String.format("Remove %d selected members", count));
                }
            }
        });
        this.members.setLayout((LayoutManager)new MigLayout("fillx, insets 0, wrap"));
        this.members.add((Component)new JLabel(ViewUtil.numToString(this.list.getRowCount()) + " " + MiscUtils.pluralize(this.list.getRowCount(), "member", "members")), "split, growx 1.0");
        this.members.add((Component)removeButton, "right,wrap");
        this.members.add((Component)this.list, "width 100%");
        this.members.updateUI();
    }

    @Override
    public void setSelectedItem(Object[] item) {
        if (item.length == 0) {
            this.blockPanel.block();
        } else {
            this.cohorts = new Cohort[]{(Cohort)item[0]};
            this.canvas.setTitle(this.cohorts[0].getName());
            this.members.removeAll();
            this.members.updateUI();
            if (this.worker != null) {
                this.worker.cancel(true);
            }
            this.worker = new CohortDetailsWorker(this.cohorts[0]);
            this.worker.execute();
        }
    }

    @Override
    public void setMultipleSelections(List<Object[]> items) {
        if (items.isEmpty()) {
            this.blockPanel.block();
        } else {
            this.cohorts = new Cohort[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                this.cohorts[i] = (Cohort)items.get(i)[0];
            }
            if (items.isEmpty()) {
                this.canvas.setTitle("");
            } else {
                this.canvas.setTitle("Multiple cohorts (" + items.size() + ")");
            }
            this.members.removeAll();
            this.members.updateUI();
        }
    }

    private JButton removeIndividualsButton() {
        JButton button = ViewUtil.getSoftButton("Remove selected member");
        button.setBackground(ViewUtil.getDetailsBackgroundColor());
        button.setOpaque(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = CohortDetailedView.this.list.getSelectedRows();
                int[] patientIDs = new int[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    patientIDs[i] = ((SimplePatient)CohortDetailedView.this.list.getModel().getValueAt(rows[i], 0)).getId();
                }
                if (patientIDs != null && patientIDs.length > 0) {
                    if (DialogUtils.askYesNo("Confirm", "Are you sure you want to remove these individual(s)?") == 1) {
                        return;
                    }
                    try {
                        MedSavantClient.CohortManager.removePatientsFromCohort(LoginController.getSessionID(), patientIDs, CohortDetailedView.this.cohorts[0].getId());
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Error removing patients from cohort.", (Throwable)ex);
                    }
                    CohortDetailedView.this.worker = new CohortDetailsWorker(CohortDetailedView.this.cohorts[0]);
                    CohortDetailedView.this.worker.execute();
                }
            }
        });
        return button;
    }

    @Override
    public JPopupMenu createPopup() {
        JPopupMenu popupMenu = new JPopupMenu();
        if (ProjectController.getInstance().getCurrentVariantTableSchema() == null) {
            popupMenu.add(new JLabel("(You must choose a variant table before filtering)"));
        } else {
            JMenuItem filter1Item = new JMenuItem(String.format("<html>Filter by %s</html>", this.cohorts.length == 1 ? "Cohort <i>" + this.cohorts[0] + "</i>" : "Selected Cohorts"));
            filter1Item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryViewController qvc = SearchBar.getInstance().getQueryViewController();
                    SearchConditionGroupItem p = qvc.getQueryRootGroup();
                    ArrayList sciList = new ArrayList(CohortDetailedView.this.cohorts.length);
                    ArrayList<String> cohortStrings = new ArrayList<String>(CohortDetailedView.this.cohorts.length);
                    for (Cohort cohort : CohortDetailedView.this.cohorts) {
                        cohortStrings.add(cohort.getName());
                    }
                    String description = StringConditionEncoder.getDescription(cohortStrings);
                    String encodedConditions = StringConditionEncoder.encodeConditions(cohortStrings);
                    qvc.replaceFirstLevelItem("Cohort", encodedConditions, description);
                    qvc.refreshView();
                    DialogUtils.displayMessage("Selected Cohorts have been added to query.  Click 'Variants' to review and execute search.");
                }
            });
            popupMenu.add(filter1Item);
        }
        return popupMenu;
    }

    private class CohortDetailsWorker
    extends MedSavantWorker<List<SimplePatient>> {
        private final Cohort cohort;

        CohortDetailsWorker(Cohort coh) {
            super(CohortDetailedView.this.getPageName());
            this.cohort = coh;
        }

        @Override
        protected List<SimplePatient> doInBackground() throws Exception {
            List<SimplePatient> patientList = MedSavantClient.CohortManager.getIndividualsInCohort(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), this.cohort.getId());
            return patientList;
        }

        @Override
        protected void showProgress(double ignored) {
        }

        @Override
        protected void showSuccess(List<SimplePatient> result) {
            CohortDetailedView.this.setPatientList(result);
            CohortDetailedView.this.blockPanel.unblock();
        }
    }
}

