/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.cohort;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.PageList;
import com.jidesoft.wizard.AbstractWizardPage;
import com.jidesoft.wizard.CompletionWizardPage;
import com.jidesoft.wizard.WizardDialog;
import com.jidesoft.wizard.WizardStyle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.sql.SQLException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.model.Cohort;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class CohortWizard
extends WizardDialog {
    private String cohortName;

    public CohortWizard() {
        this.setTitle("Cohort Wizard");
        WizardStyle.setStyle((int)3);
        PageList model = new PageList();
        model.append((AbstractDialogPage)this.getNamePage());
        this.setPageList(model);
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(null);
    }

    private AbstractWizardPage getNamePage() {
        final CompletionWizardPage page = new CompletionWizardPage("Create Cohort"){

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3302, "FINISH");
                this.fireButtonEvent(3300, "NEXT");
            }
        };
        page.addText("Choose a name for the cohort.\nThe name cannot already be in use.");
        final JTextField nameField = new JTextField();
        nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (nameField.getText() != null && !nameField.getText().equals("")) {
                    CohortWizard.this.cohortName = nameField.getText();
                    page.fireButtonEvent(3301, "FINISH");
                } else {
                    page.fireButtonEvent(3302, "FINISH");
                }
            }
        });
        page.addComponent((JComponent)nameField);
        return page;
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel bp = super.createButtonPanel();
        bp.removeButton((AbstractButton)bp.getButtonByName("FINISH"));
        JButton finishButton = new JButton("Finish");
        finishButton.setName("FINISH");
        finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CohortWizard.this.finish();
            }
        });
        bp.addButton((AbstractButton)finishButton);
        return bp;
    }

    public void finish() {
        if (this.cohortName != null && !this.cohortName.equals("")) {
            try {
                if (this.validateName()) {
                    MedSavantClient.CohortManager.addCohort(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), this.cohortName);
                    this.setVisible(false);
                }
            }
            catch (Exception ex) {
                ClientMiscUtils.reportError("Error adding cohort: %s", ex);
            }
        }
    }

    private boolean validateName() throws SQLException, RemoteException {
        Cohort[] existingCohorts = null;
        try {
            existingCohorts = MedSavantClient.CohortManager.getCohorts(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID());
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return false;
        }
        for (Cohort coh : existingCohorts) {
            if (!coh.getName().equals(this.cohortName)) continue;
            DialogUtils.displayError("Sorry", "Cohort name already in use.");
            return false;
        }
        return true;
    }
}

