/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.controller;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.controller.SettingsController;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterEvent;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class ResultController {
    private static final Log LOG = LogFactory.getLog(ResultController.class);
    private List<Object[]> filteredVariants;
    private static ResultController instance;
    private int limit = -1;
    private int start = -1;
    private int filterSetIDForRecords = -1;
    private int projectIDForRecords;
    private int referenceIDForRecords;
    private String dbNameForRecords;
    private final Object recordsLock = new Object();
    private int projectIDForTotal;
    private int referenceIDForTotal;
    private String dbNameForTotal;
    private final Object totalLock = new Object();
    private int filterSetIDForFilteredCount = -1;
    private int projectIDForFilteredCount;
    private int referenceIDForFilteredCount;
    private String dbNameForFilteredCount;
    private final Object filteredCountLock = new Object();
    private int filteredVariantCount = -1;
    private int totalVariantCount = -1;
    private FilterController filterController = FilterController.getInstance();

    private ResultController() {
        this.filterController.addListener(new Listener<FilterEvent>(){

            @Override
            public void handleEvent(FilterEvent event) {
                ResultController.this.filteredVariantCount = -1;
            }
        });
    }

    public static ResultController getInstance() {
        if (instance == null) {
            instance = new ResultController();
        }
        return instance;
    }

    public List<Object[]> getAllVariantRecords() {
        return this.filteredVariants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object[]> getFilteredVariantRecords(int start, int limit, String[] orderByCols) throws InterruptedException, SQLException, RemoteException {
        Object object = this.recordsLock;
        synchronized (object) {
            if (this.filterSetIDForRecords != this.filterController.getCurrentFilterSetID() || this.limit != limit || this.start != start || ProjectController.getInstance().getCurrentProjectID() != this.projectIDForRecords || ReferenceController.getInstance().getCurrentReferenceID() != this.referenceIDForRecords || !SettingsController.getInstance().getDBName().equals(this.dbNameForRecords)) {
                long then = System.currentTimeMillis();
                this.updateFilteredVariantDBResults(start, limit, orderByCols);
                LOG.info((Object)("Query for " + start + ", " + limit + " took " + (System.currentTimeMillis() - then) + "ms to return " + this.filteredVariants.size() + " records."));
                this.limit = limit;
                this.start = start;
                this.projectIDForRecords = ProjectController.getInstance().getCurrentProjectID();
                this.referenceIDForRecords = ReferenceController.getInstance().getCurrentReferenceID();
                this.dbNameForRecords = SettingsController.getInstance().getDBName();
            }
            return this.filteredVariants;
        }
    }

    private void updateFilteredVariantDBResults(int start, int limit, String[] orderByCols) throws InterruptedException, SQLException, RemoteException {
        this.filterSetIDForRecords = this.filterController.getCurrentFilterSetID();
        try {
            this.filteredVariants = MedSavantClient.VariantManager.getVariants(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), FilterController.getInstance().getAllFilterConditions(), start, limit, orderByCols);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFilteredVariantCount() throws InterruptedException, SQLException, RemoteException {
        Object object = this.filteredCountLock;
        synchronized (object) {
            if (this.filteredVariantCount == -1 || this.filterSetIDForFilteredCount != this.filterController.getCurrentFilterSetID() || ProjectController.getInstance().getCurrentProjectID() != this.projectIDForFilteredCount || ReferenceController.getInstance().getCurrentReferenceID() != this.referenceIDForFilteredCount || !SettingsController.getInstance().getDBName().equals(this.dbNameForFilteredCount)) {
                this.projectIDForFilteredCount = ProjectController.getInstance().getCurrentProjectID();
                this.referenceIDForFilteredCount = ReferenceController.getInstance().getCurrentReferenceID();
                this.dbNameForFilteredCount = SettingsController.getInstance().getDBName();
                int tempFilterId = this.filterController.getCurrentFilterSetID();
                try {
                    this.filteredVariantCount = MedSavantClient.VariantManager.getFilteredVariantCount(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), this.filterController.getAllFilterConditions());
                }
                catch (SessionExpiredException ex) {
                    MedSavantExceptionHandler.handleSessionExpiredException(ex);
                    return 0;
                }
                this.filterSetIDForFilteredCount = tempFilterId;
            }
            return this.filteredVariantCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalVariantCount() throws RemoteException, SQLException {
        Object object = this.totalLock;
        synchronized (object) {
            if (this.totalVariantCount == -1 || ProjectController.getInstance().getCurrentProjectID() != this.projectIDForTotal || ReferenceController.getInstance().getCurrentReferenceID() != this.referenceIDForTotal || !SettingsController.getInstance().getDBName().equals(this.dbNameForTotal)) {
                try {
                    this.totalVariantCount = MedSavantClient.VariantManager.getVariantCount(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID());
                }
                catch (SessionExpiredException ex) {
                    MedSavantExceptionHandler.handleSessionExpiredException(ex);
                    return 0;
                }
                this.projectIDForTotal = ProjectController.getInstance().getCurrentProjectID();
                this.referenceIDForTotal = ReferenceController.getInstance().getCurrentReferenceID();
                this.dbNameForTotal = SettingsController.getInstance().getDBName();
            }
            return this.totalVariantCount;
        }
    }

    public void refreshCounts() {
        this.filteredVariantCount = -1;
        this.totalVariantCount = -1;
    }
}

