/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterState;
import org.ut.biolab.medsavant.client.filter.FilterView;
import org.ut.biolab.medsavant.client.filter.QueryPanel;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public abstract class FilterHolder {
    private final String name;
    private final String filterID;
    protected final int queryID;
    protected FilterView filterView;
    private KeyValuePairPanel parent;
    private JToggleButton editButton;
    private JButton clearButton;

    public FilterHolder(String name, String filterID, int queryID) {
        this.name = name;
        this.filterID = filterID;
        this.queryID = queryID;
    }

    public String getFilterID() {
        return this.filterID;
    }

    public String getFilterName() {
        return this.name;
    }

    public boolean hasFilterView() {
        return this.filterView != null;
    }

    public FilterView getFilterView() throws Exception {
        if (this.filterView == null) {
            this.filterView = this.createFilterView();
        }
        return this.filterView;
    }

    public abstract FilterView createFilterView() throws Exception;

    public abstract void loadFilterView(FilterState var1) throws Exception;

    void addTo(KeyValuePairPanel kvp, final boolean longRunning) {
        this.parent = kvp;
        kvp.addKey(this.name);
        kvp.setKeyColour(this.name, QueryPanel.INACTIVE_KEY_COLOR);
        JLabel detailString = new JLabel("");
        detailString.setForeground(Color.orange);
        kvp.setValue(this.name, detailString);
        this.clearButton = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.CLEAR));
        this.clearButton.setVisible(false);
        kvp.setAdditionalColumn(this.name, 0, this.clearButton);
        this.editButton = ViewUtil.getTexturedToggleButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.CONFIGURE));
        this.editButton.addActionListener(new ActionListener(){
            boolean acceptedBeingLong = false;

            @Override
            public void actionPerformed(ActionEvent ae) {
                int result = 0;
                if (!this.acceptedBeingLong && FilterHolder.this.editButton.isSelected() && longRunning && (result = DialogUtils.askYesNo("Warning", "<html>This is a complex search condition that may take a long time to complete.<br>Would you like to continue anyways?</html>")) == 0) {
                    this.acceptedBeingLong = true;
                }
                if (result == 0) {
                    FilterHolder.this.openFilterView();
                } else {
                    FilterHolder.this.editButton.setSelected(false);
                }
            }
        });
        kvp.setAdditionalColumn(this.name, 1, this.editButton);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    FilterController.getInstance().removeFilter(FilterHolder.this.filterID, FilterHolder.this.queryID);
                    FilterHolder.this.filterView = null;
                    FilterHolder.this.clearButton.setVisible(false);
                    FilterHolder.this.editButton.setSelected(false);
                    FilterHolder.this.parent.toggleDetailVisibility(FilterHolder.this.name, false);
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Error removing filter: %s", ex);
                }
            }
        });
    }

    public void openFilterView() {
        block2: {
            try {
                this.parent.setDetailComponent(this.name, this.getFilterView());
                this.parent.toggleDetailVisibility(this.name);
                this.parent.updateUI();
            }
            catch (Exception ex) {
                this.filterView = null;
                this.editButton.setSelected(false);
                if (ex instanceof InterruptedException) break block2;
                DialogUtils.displayException("Problem displaying filter", "Problem getting values for filter " + this.name, ex);
            }
        }
    }
}

